/*
**	(C) Centrum voor Wiskunde en Informatica, 1985
**
**	This software may be freely distributed and used, save
**	for profit or military purposes, provided always this notice
**	is retained.
**
**	No warranty is made on the suitability of this software
**	for any purpose whatsoever.
**
**	Last modified:
**
**	Ken Yap (CWI) August 1985
*/

/*
**	A program to generate alternate spellings from a mispelled word
**	and return those that are in the dictionary.
**
**	Ken Yap, CWI, July 1985
*/

#include	<sys/types.h>
#include	<sys/file.h>
#include	<ctype.h>
#include	<stdio.h>
#include	<signal.h>

#ifdef	AMOEBA
#include	"amoeba.h"
#endif	AMOEBA

#include	"word.h"

static char	*dictfile	= DEFAULT_DICT;
static int	server		= 0;
static int	debug		= 0;
static int	fold		= 0;
static int	sortuniq	= 1;
static char	ibuf[1024], buf[10240];

#ifdef	AMOEBA
header		hdr;
#endif	AMOEBA

/*
**	Print message and exit on error
*/
chkerror(cc, msg)
	int	cc;
	char	*msg;
{
	if (cc < 0)
	{
		perror(msg);
		exit(1);
	}
}

cleanup()
{
	exit(0);
}

/*
**	Generate one word's permutations
**	Reject words containing non-alphabetics
*/
int altgen(word, buf, len)
	char		*word, *buf;
	int		len;
{
	register int	op;
	register char	*p;

	for (p = word; *p != '\0'; p++)
		if (!isalpha(*p))
			return (0);
	p = buf;
	for (op = DEL1CHAR; op <= ADD1CHAR; op++)
	{
		transform(word, INIT, p);
		while (transform(word, op, p))
		{
			p += strlen(p);
			*p++ = '\n';
			if (p - buf > len - 20)
				return (p - buf);
		}
	}
	*p = '\0';
	return (p - buf);
}

/*
**	Pick up one word from buf, returning updated position in buf
*/
char *getword(buf, word, wlen)
	char		*buf, *word;
	int		wlen;
{
	while (isspace(*buf) && *buf != '\0')
		buf++;
	while (!isspace(*buf) && *buf != '\0')
	{
		if (wlen-- <= 0)
			break;
		*word++ = *buf++;
	}
	*word = '\0';
	return (buf);
}

/*
**	Lookup several words
*/
int lookup(words, alternates, altlen)
	char		*words, *alternates;
	int		altlen;
{
	register int	l, ch;
	register char	*p, *tempfile;
	register FILE	*tempf, *cmdpipe;
	char		word[64];
	int		dup2();
	char		*getword(), *mktemp();
	FILE		*fopen(), *popen();

	tempfile = mktemp("/tmp/correctXXXXXX");
	if ((tempf = fopen(tempfile, "w")) == NULL)
		chkerror(-1, tempfile);
	p = words;
	while (*(p = getword(p, word, sizeof(word))) != '\0')
	{
		if (debug) printf("<%s>\n", word);
		l = altgen(word, alternates, altlen);
		fwrite(alternates, sizeof(char), l, tempf);
	}
	fclose(tempf);
	sprintf(word, "spellout -d %s < %s %s", dictfile, tempfile,
		sortuniq ? "| sort -u" : "");
	if ((cmdpipe = popen(word, "r")) == NULL)
		return (-1);
	p = alternates;
	while ((ch = getc(cmdpipe)) != EOF)
	{
		*p++ = ch;
		if (p - alternates > altlen)
			break;
	}
	pclose(cmdpipe);
	unlink(tempfile);
	return (p - alternates);
}

#ifdef	AMOEBA
dictserver()
{
	register int	n;
	int		amoeba_init(), getreq(), putrep(), lookup();

	strncpy((char *)&hdr.h_port, "bodict", PORTSIZE);
	chkerror(amoeba_init(&hdr.h_port), "init");
	for (;;)
	{
		do {
			if ((n = getreq(&hdr, ibuf, sizeof(ibuf))) < 0)
			{
				perror("getreq");
				continue;
			}
			ibuf[n] = '\0';
			n = lookup(ibuf, buf, sizeof(buf));
			if (putrep(&hdr, buf, n) < 0)
				perror("putrep");
		} while (n > 0);
	}
}
#endif	AMOEBA

lower(p)
	char		*p;
{

	for ( ; *p != '\0'; p++)
		if (isupper(*p)) *p = tolower(*p);
}

main(argc, argv)
	int		argc;
	char		*argv[];
{
	register int 	i;		/* the option flag name */
	register char	*words;
	extern int	optind;		/* defined in getopt */
	extern char	*optarg;	/* defined in getopt */
	int		getopt();

	while ((i = getopt (argc, argv, "DSd:fs")) != EOF)
	{
		switch (i)
		{
		case 'D':	debug++; break;
		case 'S':	server++; break;
		case 's':	sortuniq = 0; break;
		case 'd':	dictfile = optarg; break;
		case 'f':	fold++; break;
		default:
				fprintf (stderr, "usage: %s [-DSfs] [-d dictfile] [words]\n", argv[0]);
				exit (1);
		}
	}
	signal(SIGTERM, cleanup);
#ifdef	AMOEBA
	if (server)
		dictserver();
	else
#endif	AMOEBA
	{
		words = ibuf;
		for (argc -= optind, argv += optind; argc > 0; argc--, argv++)
		{
			strcpy(words, *argv);
			words += strlen(words);
			*words++ = ' ';
		}
		i = (words == ibuf) ? (fgets(ibuf, sizeof(ibuf), stdin), strlen(words))
			: words - ibuf;
		words[i] = '\0';
		if (fold) lower(ibuf);
		chkerror((i = lookup(ibuf, buf, sizeof(buf))), "pipe");
		write(1, buf, i);
	}
}
