/*
**	(C) Centrum voor Wiskunde en Informatica, 1985
**
**	This software may be freely distributed and used, save
**	for profit or military purposes, provided always this notice
**	is retained.
**
**	No warranty is made on the suitability of this software
**	for any purpose whatsoever.
**
**	Last modified:
**
**	Ken Yap (CWI) August 1985
*/

#include	<ctype.h>
#include	"word.h"

int transform(word, op, result)
	char		*word, *result;
	int		op;
{
	register int	i;
	static struct {
		int		len, pos;
		char		let;
		} context;

	switch (op)
	{
	case INIT:
		context.len = strlen(word);
		context.pos = 0;
		context.let = isupper(*word) ? 'A' : 'a';
		break;
	case DEL1CHAR:
		if (context.pos >= context.len)
			return (0);
		for (i = 0; i < context.pos; i++)
			*result++ = word[i];
		for (i = context.pos + 1; i < context.len; i++)
			*result++ = word[i];
		context.pos++;
		break;
	case SWAP2CHARS:
nextpos:
		if (context.pos >= context.len - 1)
			return (0);
		for (i = 0; i < context.pos; i++)
			*result++ = word[i];
		if (word[i] == word[i+1])
		{
			context.pos++;
			goto nextpos;
		}
		*result++ = word[i+1];
		*result++ = word[i];
		for (i = context.pos + 2; i < context.len; i++)
			*result++ = word[i];
		context.pos++;
		break;
	case CHG1CHAR:
		if (context.pos >= context.len)
			return (0);
		for (i = 0; i < context.pos; i++)
			*result++ = word[i];
		*result++ = context.let;
		for (i = context.pos + 1; i < context.len; i++)
			*result++ = word[i];
		if (context.let == 'Z' || context.let == 'z')
		{
			context.pos++;
			context.let = isupper(word[context.pos]) ? 'A' : 'a';
		}
		else
			context.let++;
		break;
	case ADD1CHAR:
		if (context.pos > context.len)
			return (0);
		for (i = 0; i < context.pos; i++)
			*result++ = word[i];
		*result++ = context.let;
		for (i = context.pos; i < context.len; i++)
			*result++ = word[i];
		if (context.let == 'Z' || context.let == 'z')
		{
			context.pos++;
			context.let = isupper(word[context.pos]) ? 'A' : 'a';
		}
		else
			context.let++;
		break;
	default:
		;
	}
	*result = '\0';
	return (1);
}

#ifdef	TEST
main(argc, argv)
	int		argc;
	char		*argv[];
{
	register int	op;
	char		buf[5120];

	if (argc <= 1)
		exit(1);
	for (op = DEL1CHAR; op <= SWAP2CHARS; op++)
	{
		printf("Transformation #%d\n", op);
		transform(argv[1], INIT, buf);
		while (transform(argv[1], op, buf))
			printf("%s\n", buf);
	}
	exit(0);
}
#endif	TEST
