/* partbibtex.c */

static char rcsid[] = "$Header$";
/*
**
**     Author unknown
**
*/
#include <stdio.h>
#ifdef SYSV
#include <string.h>
#define index strchr
#endif
#ifdef BSD
#include <strings.h>
#endif
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

FILE * in;
#define BUFLEN 600000
#define STRLEN 400

extern char *getenv();

main (argc, argv)
int argc;
char * argv[];
{
	FILE * fopen();
	char * key;
	int caseop = 1;
	int ret ,length, iseof, print, lnlen, keylen, i, j;
	struct stat stbuf;
	char buf[BUFLEN];
	char filename[STRLEN];
	char actstr[STRLEN];
	char *texinputs, *top, *end;

	argv++, argc--;
	if (!argc)
		fprintf(stderr,"usage:partbibtex [-c] keyword <files>\n"), exit(1);
	if (argv[0][0] == '-')
	{
		if (argv[0][1] == 'c')
			caseop = 0;
		else
		    fprintf(stderr,"usage:partbibtex [-c] keyword <files>\n"), exit(1);
		argv++, argc--;
	}
	key = *argv;
	keylen = strlen(key);
	if (argc <= 1)
		fprintf(stderr,"usage:partbibtex [-c] keyword <files>\n"), exit(1);
	texinputs = getenv("TEXINPUTS");
	while (--argc,++argv, argc>0 ) {
		if ((texinputs != NULL) && (**argv != '/')) {
			if (STRLEN <= (strlen(texinputs) + strlen(*argv)))
			  fprintf(stderr, "Warning: Environment String too long\n");
			strncpy(actstr,texinputs,STRLEN);
			top = actstr;
			end = actstr;
			ret = -1;
			while (end != NULL) { /* evaluate TEXINPUTS */
				end = index(top,':'); /* Search for first : */
				if (end != NULL) *end = '\0'; /* modify : to \0 */
				strncpy(filename,top,STRLEN);
				if (end != NULL) top = ++end;
				if (!(length = strlen(filename))) continue;
				filename[length++] = '/';
				filename[length] = '\0';
				strcat(filename,*argv);
				if ((ret = stat(filename,&stbuf)) ==  0)  break;
			}
			if (ret < 0) {
				fprintf(stderr,"file not found: %s\n",*argv);
				continue;
			}
		}
		else strcpy(filename,*argv); /* TEXINPUTS was not set or filename
					begins with a / */

		if (stat(filename,&stbuf) < 0) {
			fprintf(stderr,"file not found: %s\n",filename);
			continue;
		}
		if ((stbuf.st_mode & S_IFMT) != S_IFREG) {
			fprintf(stderr," %s is not an ordinary file\n",filename);
			continue;
		}
		if ((in=fopen(filename,"r")) == NULL) {
			fprintf(stderr,"%s can not be opened\n",filename);
			continue;
		}
		print = lnlen = 0;
		while (1) {
			iseof = getline(buf,&lnlen);
			for (i=j=0; i<(lnlen+j-keylen) ; i++)
				if (key[j] == buf[i] || (caseop && (
				(key[j] == (buf[i]+32) && isupper(buf[i])) ||
				    (key[j] == (buf[i]-32) && isupper(key[j]))))) {
					if (++j == keylen) {
						print = 1;
						break;
					}
				}
				else
					j=0;
			if (print) {
				for (i=0 ; i<lnlen ; i++)
					putchar(buf[i]);
				print = 0;
			}
			if (iseof == EOF)
				break;
		}
	}
	exit(0);
}


int getline(line,len)
char * line;
int * len;
{
	int count = 0;

	if ((*line = getc(in)) == EOF)
		return(EOF);
	else
	    count++, line++;
	while ((*line = getc(in)) != EOF && *line != '@' ) {
		count++;
		line++;
		if (count > BUFLEN) {
			fprintf(stderr,"Entry too long\n");
			exit(1);
		}
	}
	*len = count;
	if (*line == EOF)
		return(EOF);
	else
		ungetc(*line, in);
	return(count);
}
