/*
    Module:	xcsubs.c	XCOMM Subroutines

    Revisions:

    2.2		lg	Now uses /dev/tty instead of stdin/stdout
    2.2		lg	Added command parser
*/

#include <stdio.h>
#include <ctype.h>
#include <signal.h>
#include <termio.h>

#include "xcomm.h"

extern struct termio newmode, sigmode;
extern FILE *tfp;	/* Local terminal */
extern int tfd;		/* Local terminal */

char line[WBSIZE];	/* Input line */
char word[WBSIZE];	/* Parsed word */
char *wptr, *lptr;	/* Word and line pointers */
int quote_flag = 0;	/* Indicates special processing during parse */
int eof_flag = 0;	/* Indicates EOF during getline() processing */

sendstr(p)              /* send a string to the port */
register char *p;
{
    while(*p)
        send_mbyte(*p++);
}

/* Do the fork call, packaging the error return so that the caller
 * need not have code for it.
 */

forkem()
{
    int i;

    if((i = fork()) < 0){
        fprintf(tfp,"XCOMM: Fork failed");
        longjmp(erret, 1);
    }
    return(i);
}


/* Convert uppercase characters to lowercase, (without
 * mangling non-uppercase characters), in a portable manner.
 */
mklow(c)
int c;
{
    if(isupper(c))
        return(tolower(c));
    return(c);
}

/* This is an string input routine to be used
 * when the raw terminal mode is in effect.
 */
getsome(s)
char *s;
{
    int c, i;

    if (s == line) {
	lptr = line;
	memset(line, 0, WBSIZE);
    }

    i = 0;
    while((c = coninp()) != '\r' && c != '\n') {
        if(c == '\b'){
            if(i > 0){
                i--;
                fprintf(tfp,"\b \b");
            } else
                putc(7, tfp);
            continue;
        }
        s[i++] = c;
        putc(c, tfp);
    }
    s[i] = '\0';
    putc(' ', tfp);
}

/*
    Erase current line without moving downwards
*/

erasln()
{
    int i;

    putc('\r', tfp);
    for(i = 0; i < 79; i++)
        putc(' ', tfp);
    putc('\r', tfp);
}

/* 
    Throw away all input characters until no more are sent.
*/

purge()
{
    while(readbyte(1) != -1)
        ;
}

/*
    Parse the "line" array for a word
*/

getword()
{
    char *ptr = word;
    char quote = '\0';
    int bflag = 0, qflag = 0;
    int c;

    *ptr = '\0';
    if (eof_flag || *lptr == '\0')
	return;

    while (isspace(*lptr))
	lptr++;

    wptr = lptr;

    if (*lptr == '\0')
	return;

    if (*lptr == '\'' || *lptr == '\"')
	quote = *lptr++;
    else
	quote = '\0';

    for (; *lptr != '\0'; lptr++) {
	if (quote) {
	    if (*lptr == '\0') {
		word[0] = '\0';
		fprintf(tfp, "Unmatched quote: %s\r\n", line);
		eof_flag = 1;
		return;
	    }
	    if (*lptr == quote)
		break;
	} else if (!qflag && isspace(*lptr))
	    break;

	if (bflag)
	    *ptr++ = *lptr & 0x1f;
	else if (qflag)
	    *ptr++ = *lptr;
	else if (quote_flag && *lptr == '^')
	    bflag = 1;
	else if (quote_flag && *lptr == '\\')
	    qflag = 1;
	else
	    *ptr++ = *lptr;
    }

    lptr++;
    *ptr = '\0';
}

/*
    Make the specified word all lower case
*/

lc_word(ptr)
 char *ptr;
{
    while (*ptr) {
	*ptr = mklow(*ptr);
	ptr++;
    }
}

/*
    Input a line from the specified file
*/

getline(fp)
 FILE *fp;
{
    int l;

    memset(line, 0, WBSIZE);

    if ((fgets((lptr=line), WBSIZE, fp)) == NULL) {
	eof_flag = 1;
	line[0] = '\0';
    }

    l = strlen(line);		/* Purge newline if found */
    if (l--) {
	if (line[l] == '\n')
	    line[l] = '\0';
    }
}

/*
    trminp() is used as a single-character terminal input routine
*/

static alrm() {}  /* do nothing */

int trminp(fd, seconds)
 int fd, seconds;
{
    static char rxbuf[BUFSIZ], *p;      /* BUFSIZ is defined in stdio.h */
    static int count = 0;

    if(count > 0){
        count--;
        return(*p++ & 0xff);
    }
    if(seconds > 0){
        signal(SIGALRM, alrm);
        alarm((unsigned)seconds);
    }
    if((count  = read(fd, p = rxbuf, BUFSIZ)) < 1)
        return(-1);
    if(seconds > 0)
        alarm(0);
    count--;
    return(*p++ & 0xff);
}

/*
    coninp() gets a single character from the local terminal
*/

coninp()
{
    int c;

    fflush(tfp);

    while ((c = trminp(tfd, 0)) == -1)
	;

    return c;
}

intdel(flag)
{
    if (flag)
	ioctl(tfd, TCSETAW, &sigmode);
    else
	ioctl(tfd, TCSETAW, &newmode);
}

#if	!HAVE_STRDUP
char *
strdup(s)
char *s;
{
    extern char *calloc(), *strcpy();
    char *r = calloc(1, strlen(s)+1);

    return(strcpy(r, s));
}
#endif /* !HAVE_STRDUP */
