/*
    XCOMM Global Definitions
*/

#define ENQ		0x05		/* CIS ENQ */

#define ESCAPE_CHR	0x1b

#define ENDCHAR        (('X' & 0x1f) + 128)	/* Exit terminal mode */
#define TOGCHAR        (('T' & 0x1f) + 128)	/* Toggle capture buffer */
#define DIVCHAR        (('F' & 0x1f) + 128)	/* Send file through modem */
#define PSELECT        (('D' & 0x1f) + 128)	/* Dial from phonelist */
#define HUPCHAR        (('H' & 0x1f) + 128)	/* Hang up modem */
#define	SCRPCHR	       (('G' & 0x1f) + 128)	/* Execute script file */

#define	CAPTFILE	"capture.log"	/* Default capture file */
#define PHFILE		".phonelist"	/* Default phonelist file */
#define STARTUP		".xcomm"	/* XCOMM Startup Script */
#define DRIBBLE		2		/* Text "dribble" delay */
#define PUT_TAKE			/* include put/take code */
#define	CIS_INIT	1		/* cismode default 1=on/0=off */

#define HAVE_DUP2	1		/* 0 if dup2() not available */
#define	HAVE_STRSTR	0		/* We have to define strstr() */
#define	HAVE_STRDUP	0		/* We have to define strdup() */

#define	DTR_DROPS_CARRIER	1	/* Dropping DTR drops carrier */

/*
    Some Berkely and Xenix systems have index() and rindex() which are
    functionally identical to the more standard strchr() and strrchr()
    functions.  Drop these defines if your Unix does supports index and
    rindex INSTEAD of strchr and strrchr.
*/

#define index           strchr		/* for SYSV */
#define rindex          strrchr		/* for SYSV */

/*
    Other defines
*/

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

#define K       1024
#define NMSIZE  256             /* file name buffer size */
#define WBSIZE  256             /* input and working buffer size */

/* globals */

#include <setjmp.h>

extern jmp_buf erret;
extern int verbose, mungmode, bitmask, cbsiz, crcheck, badline, flowflag;
extern int cismode, linkflag, quote_flag, eof_flag, nlmode, scriptflag;
extern char captfile[NMSIZE], phonefile[NMSIZE], *mport();
extern char word[], *wptr, line[];

struct kw {			/* Used by command parsing routines */
    char *keyword;
    void (*rtn)();
};
