.TH XCOMM 1L "29 Oct 1988" Local LOCAL
.SH NAME
xcomm \- X-modem communications program
.SH SYNOPSIS
.B xcomm
[
.B \-options
]
.SH OPTIONS
.IP "-l device"
(Line option) Specifies the path name to be used for the modem device.  
This overrides the value of the MODEM environment variable.  
.LP
Note that if the MODEM environment variable is not set, the -l Line option 
is mandatory.  
.LP
The MODEM environment variable is used as the default path name to be used 
for the modem device.  If this environment variable is not set, the -l 
Line option is mandatory.  (/dev/cua0 is the correct line for the
modem on "ufnmr" - GJB).
.LP
The MODEM variable is usually set in a shell profile.  In the Bourne 
shell, this is placed in the .profile file of your home directory with 
statements similar to that shown below:  
.sp
	export MODEM; set MODEM="/dev/tty00"
.sp
(assuming your modem device is /dev/tty00).  Using the C Shell, the 
following statement may be place in .cshrc in your home directory:  
.sp
	setenv MODEM "/dev/tty00"
.IP "-g file"
(GO option) Specifies a script to be executed as soon as \fIxcomm\fP is finished 
initializing.  
.IP -t
(Terminal option) Directs \fIxcomm\fP to jump directly into terminal mode after 
initializing.  
.LP
Entering \fIxcomm\fP with an invalid option will display a summary of the valid
options supported.
.SH DESCRIPTION
.LP
\fIXcomm\fP is a public domain terminal program that currently features
.sp
o XMODEM and CIS "QuickB" file transfers with optional "text" translation
.br
o Hayes Modem dialing directory with BAUD and BIT parameters
.br
o Unix CU compatible PUT and TAKE commands
.br
o Simple HOST communication mode
.br
o Communication scripting with optional linkage from phone directory.
.LP
\fIXcomm\fP is offerred free of charge with NO requests for financial compensation
reqested (this is public domain, not shareware).  The source code may be
used or modified by anyone, but this code, or derivations of this code,
may not be sold by anyone to anyone.
.SH "COMMAND SUMMARY"
.LP
\fIXcomm\fP prompts for commands using the string:
.sp
    XCOMM>
.sp
With version 2.2, \fIxcomm\fP supports the following commands:
.IP c		
Initiate CIS QuickB File Transfer.  This command is used for both uploading and
downloading from CompuServe.
.IP "g file"
Execute the \fIxcomm\fP script file "file".  Returns to terminal mode when the
script is complete.
.IP "rb file"
.IP "rt file"
XMODEM receive (rb = binary mode; rt = text mode).  Receive the specified
file from the remote system.
.IP "sb file"
.IP "st file"
XMODEM transmit (sb = binary mode; st = text mode).  Transmit the specified
file to the remote system.
.IP set
Display or set the transmission parameters used by the \fIxcomm\fP program.  Refer
to the SET section of this document.
.IP t
Enter terminal mode.  Refer to the TERMINAL section of this document.
.IP x
Exit program.  Return to invoking program/shell.
.IP "! <cmd>"
Execute the specified command as a child process.  If <cmd> is ommitted,
execute a local interactive shell.
.IP "!!"
Re-execute the last shell command string.
.IP $
Execute a shell command with stdin and stdout redirected to the modem port.
This effectively puts the computer into a "host" mode.
.IP "%p file"
Transmit a file (put) to a remote Unix system.  This command uses standard Unix
utilities on the other end.
.IP "%t file"
Receive a file (take) from a remote Unix system.  This command uses standard
Unix utilities on the other end.
.IP ?
Print a short \fIxcomm\fP command summary.
.SH "FILE TRANSFERS - TEXT AND BINARY MODES"
.LP
When transferring files using the XMODEM protocol, the file mode is
specified int the upload/download command.  A "Text" file transfer enables
special translation of the transmitted or received file to support CP/M and
MS-DOS end of line characters.  When transmitting a file using text mode,
all newlines are converted to carriage-return, newline sequences.  When
receiving a file using text mode, all carriage-return, newline sequences are
converted to a single newline.  A "binary" file transfer transmits the file
"as is" without any conversion.
.LP
When transferring files using CompuServe QuickB protocol, the format of the
file is specified by the host.  An "Ascii" file will force \fIxcomm\fP to perform
text-mode translation; a "binary" file will turn off any translation.
.SH "THE SET COMMAND"
.LP
The SET command is used to display and set/reset \fIxcomm\fP's tunable parameters.
The usage is shown below:
.IP (1) set
Display \fIxcomm\fP's current parameters.
.IP (2)   
set 7bit
.br
set 8bit
.br
set crc
.br
set chk
.br
set term
.br
set cmd
.br
set cr
.br
set nl
.LP
Set the indicated parameter:
.RS +0.5i
.IP 7bit	
Modem high-bit masking.  All characters received from the
modem are masked so their values are between 0 and 127.
This is useful for remote systems that transmit parity
characters (the parity is ignored).
.IP 8bit	
Disable Modem high-bit masking.  All characters received
from the modem are displayed verbatim.
.IP crc	
Set XMODEM CRC protocol.  All transferred blocks use a
16-bit block check, which is more reliable than the older
"checksum" block check.
.IP chk	
Set XMODEM Checksum protocol.  All transferred blocks use an
8-bit block check, which is not as reliable as the CRC
block check, but is compatible with older programs using
XMODEM.
.IP term	
Set auto-jumpback to terminal mode after all file transfers.
.IP cr	
Set newline translation mode (in terminal mode, all newlines
will be translated to carriage returns).
.IP nl	
Set carriage return mode (in terminal mode, all newlines are
sent as newlines; carriage returns are sent as carriage
returns.)
.LP
The above parameters are paired; that is, the "crc" parameter is
negated by the "chk" parameter.
.LP
XMODEM Transfers:  When using "crc" protocol on a transmit, the \fIxcomm\fP
program will fall back to "checksum" block checks if the receiving
program does not support the special "crc" handshake.
.RS -0.5i
.IP (3)   
set cis   on|off
.br
set mung  on|off
.br
set purge on|off
.br
set xoff  on|off
.br
set baud  <value>
.br
set cfile name
.br
set pfile name
.RS +0.5i
.IP cis	
Set CompuServe <ENQ> file transfer requests.  An "on" value
specifies that when in terminal mode, an <ENQ> character
will perform an automatic CIS QuickB protocol transfer.
This parameter should be set "off" when not connected to
CompuServe, as phone line noise may cause a bogus file
transfer request.
.IP mung	
Set file overwrite flag.  If "on", files may be overwritten
when receiving data files.  If "off", files will not be
overwritten (will cause an error message to be displayed).
.IP purge	
Set Bad Telephone Line Purge mode.  If "on", removes
spurious characters received through the phone line due to
noise before listening for an acknowledgement.  This
increases the amount of time spent transmitting each block,
but can improve throughput overall by reducing the number of
block retransmissions.
.IP xoff	
Set XON/XOFF flow control flag.  If "on", the program will
honor the XOFF control character and wait until an XON
character is received before transmitting any more
information.  If "off", the program will ignore XOFF/XON
requests.
.IP baud	
Set the desired baud rate.  Supported baud rates are 300,
1200, 2400, 4800, and 9600 baud.
.IP cfile	
Set the name of the terminal mode capture file to "name".
.IP pfile	
Set the name of the terminal mode phonelist file to "name".
.RS -0.5i
.LP
A sample "set" command status display is shown below:
.sp
.RS +0.5i
Modem port is '/dev/tty00'.
.br
Speed is 1200 baud.
.br
Seven-bit communication mask enabled.
.br
XMODEM CRC protocol enabled.
.br
Extra bad telephone line purging enabled.
.br
Capture save file is 'capture.log'.
.br
Phone number file is '.phonelist'.
.br
XON/XOFF Flow control is OFF.
.br
CIS <ENQ> Auto Download is ON.
.br
Newline translation mode is active.
.sp
.RS -0.5i
.SH "TERMINAL MODE"
.LP
In terminal mode, all characters typed at the keyboard are sent to the
modem; all characters received from the modem are displayed on the local
terminal screen.
.LP
Newline characters (0x0A) are translated to carriage returns (0x0D) when
Newline mode is active.
.LP
When the ESC key is typed in terminal mode, the program will examine the
next key pressed.  If it is a special command function, that function will
be performed; otherwise, the second character is sent to the modem.  Thus,
to send an ESC character through the modem, it is necessary to press the
key TWICE.
.LP
Supported ESC commands:
.IP "ESC f	send File"
Send a file through the modem (ascii transfer).  An
option is available for waiting after each line is
sent to avoid overrunning the remote systems input
buffer.
.IP "ESC g	script (GO)"
Execute a script file.
.IP "ESC h	Hangup"
Disconnect from the remote system.
.IP "ESC t	Toggle capture"
Toggle capture file - If the file is not open, it is
opened in APPEND mode (text receive accumulates at
the end of the file).  If the file is already open,
it is closed, instead.
.IP "ESC x	eXit"
Exit terminal mode back to \fIxcomm\fP command mode.
.SH "PHONELIST"
The .phonelist must exist with the file name ".phonelist" either in the
current directory, or your home directory as defined by the $HOME
environment variable.  The name of the phonelist file can be changed
using the SET PFILE command.
.LP
The .phonelist file is ASCII text (lines of text separated by newlines).
It can be created and maintained using emacs, vi, or even ed.
The first field of data in each line (after any whitespace and up to the
next occurance of whitespace) is assumed to be a phone number in a valid
format for the modem being dialed.
Any text may follow the phone number.
.LP
Special strings within each line:
.br
BITS=x	(x=7|8) - Set the terminal mode mask to 7/8 bits.
.b
rBAUD=nnnn	(n=300|1200|2400|4800|9600) - Set the baud rate to the
specified value
.br
SCRIPT=file	Immediately after sending the autodial string, execute the
script file specified. (Note that the specified filename is
CASE SENSITIVE!)
.sp
A sample entry is shown below:
.sp
687-0374	CompuServe		BITS=7	BAUD=1200, SCRIPT=cis.cmd
.sp
The above entry indicates that the number to be dialed is 687-0374; the
bit mask is to be set to seven bits (ignore high bits), the baud rate is
to be set to 1200 baud, and commands are to be taken from the file
"compusrv.cmd" in either the current or home directory.
.LP
A sample .phonelist file is included in the \fIxcomm\fP source code
distribution.
.SH "XCOMM SCRIPT LANGUAGE"
.LP
Script files can automate some tedious tasks such as logging into a
system.  A script file is an Ascii text file and may be entered or
edited using any standard Unix text editor.
.LP
The script file is read line by line.  Empty lines (consisting of white
space only) are ignored.  Comments are lines whose first non-space
character is a pound sign (#).
.LP
The script processor reads each script line, ignoring leading white
space, into "words".  A word is defined as either:
.sp
- A sequence of characters delimited by white space; or
.br
- A sequence of characters enclosed in single or double quotes.
.sp
.LP
The first word of a script file is considered the "command word."
If the last character of the command word is a colon (:), the line is
considered to be a LABEL (the object of a GOTO statement).  Otherwise,
it is assumed to be a script command and is interpreted as such.
Command words are case insensative.
.LP
Some commands take one or more arguments.  Each argument is parsed as a
single word as defined above.  If blanks are required in an argument,
the argument MUST be quoted using single or double quotes.
.LP
Enclosed in the \fIxcomm\fP distribution is the file "compusrv.cmd".  This is
an example script file (No, that is not really my user ID or my
password in that file!), and shows the use of most of the available
script commands.  The script commands are self explanatory for the most
part.
.SH "STARTUP SCRIPTS"
.LP
When \fIxcomm\fP is started up, it looks for the file ".xcomm" in the current
or $HOME directory.  If it is found, it is executed.  This is useful for
setting your "basic" parameters without having to recompile \fIxcomm\fP.  For
example, your startup file may turn CIS <ENQ> mode off, set your baud
rate to 9600, and set 7BIT translation.
.SH "SCRIPT COMMAND LIST"
.IP "CAPTURE ON|OFF"
The command CAPTURE ON will open the capture command; all characters
received during WAITFOR processing will be appended to the capture file.
The command CAPTURE OFF will close the capture file.
.br
This setting does NOT currently extend to terminal mode.  This may be
offered in a later release (probably through the SET command).
.IP "DIAL <number>"
Dial the specified number.  \fIxcomm\fP supports generic "Hayes" compatible
modems for dialing.  Note that this command requires an actual phone
number; the phonebook is not used for this function.
.IP "ECHO ON|OFF"
If the argument to the ECHO command is ON, all subsequent command lines
that are processed will be displayed on the local screen.  The exception
to this is lines containing a TRANSMIT command.  These lines will just
print "TRANSMIT ...", so that passwords, etc. can be protected.
.br
If the argument to the ECHO command is OFF, scripts will execute
quietly (this is the default setting).
.IP EXIT
Terminate the script file prior to the end of file.  Returns to terminal
mode.
.IP "GOTO <label>"
Go to the specified label in the script file and continue execution from
that point.  The label may either precede or follow the actual GOTO
statement.
.IP "IF <condition>"
.IP "<statements>"
.IP "[ ELSE"
.IP "statements ]"
.IP "ENDIf"
Conditionally execute statements based on specified condition.  \fIXcomm\fP
supports the following conditions:
.sp
WAITFOR		TRUE if the last WAITFOR command was successful
LINKED		TRUE if this script was executed from the phonebook
.sp
Conditions may be negated using the prefix NOT or the character "!":
.sp
!WAITFOR		TRUE If the last WAITFOR command timed out
NOT WAITFOR		Same as !WAITFOR above
.sp
The ELSE and ENDIF keywords must appear on their own lines.  IF
statements may not be nested.
.IP "PAUSE <time>"
Suspend execution of the script for the specified number of seconds.
This is usually used for timing considerations; for example, waiting a
couple of seconds after receiving the CONNECT message and typing ^C to
CompuServe.
.IP "QUIT"
Terminate the script AND the \fIxcomm\fP program (return to the shell).
.IP "REDIAL"
Redial the last number dialed using the DIAL command OR the phonebook.
.IP "SET <parameter> <value>"
Sets the specified parameter to the specified value.  The SET parser
used in command mode is used, and the parameters/values are identical.
.br
During script processing, internal status messages are NOT displayed on
the local terminal (eg, SET 7BIT ON in a script file does not display
the new value on the terminal).  This may be changed in the future
(probably tied to the ECHO setting).
.br
During script processing, specifying SET alone is an ERROR... there is
no way currently display the current status of the SET-able parameters
during script processing.
.IP "TRANSMIT <text>"
Transmit the specified text to the remote.  The text argument should be
quoted (using single or double quotes) if there are spaces to be
transmitted.  The text is transmitted AS IS (no case conversions are
performed).
.br
Prefix characters:
.sp
^	Control character prefix - The next character is made into a
control character.  
For example:  ^M = RETURN (0x0D); ^J = NEWLINE (0x0A).
.sp
\	Quote prefix - The next character is transmitted verbatim.  For
example, \^ would transmit a literal ^.
.IP "TTY ON|OFF"
The TTY command specifies whether or not characters received from the
modem will be displayed on the local terminal.  Since the only time that
the script processor looks at the receive queue is during WAITFOR
processing, the displays may look a bit erratic.
.br
Use the TTY OFF command to disable local display of received characters
during script processing.
.IP "WAITFOR <text> [timeout]"
Wait for the specified text to appear from the modem.  The text argument
should be quoted (using single or double quotes) if there are spaces to
be transmitted.
.br
Special characters are interpreted the same as for TRANSMIT.
.br
If the timeout argument is specified, \fIxcomm\fP will wait that number of
seconds for the string to appear.  If no timeout is given, \fIxcomm\fP
defaults to 30 seconds.
.br
During WAITFOR processing, characters received (up to and including the
last character found in the text or in the timeout) can be captured to a
disk file (if CAPTURE ON was specified), and/or displayed to the screen
(if TTY ON was specified).
.SH "BUGS"
.LP
\fIXcomm\fP does not support or respect uucp/tip LCK lock files.  
Check that the modem is free before trying to use \fIxcomm\fP.
.SH "AUTHOR"
.LP
My electronic addresses are:
.sp
Compu$erve:		[72236,3516]   (UNIXFORUM)
.br
Delphi:			larryg
.br
Bix:			lar3ry
.br
Andover CNode:		larry gensch
(This is a FIDO BBS dedicated to C Language
programming - phone number (617) 470-2548)
