#include "../condevs.h"
#include <ctype.h>

#ifdef COURIER

#define CTMOUTLS 30	/* low speed timeout */
#define DEFBAUD 2400	/* interface speed during connect fase */
/*
 *	I set the courier switches as follows to run it with
 *	this dialer:
 *	sw 1	--	off
 *	sw 2	--	on
 *	sw 3	--	off
 *	sw 4	--	on
 *	sw 5	--	off
 *	sw 6	--	off
 *	sw 7	--	on
 *	sw 8	--	on
 *	sw 9	--	on
 *	sw 10	--	off
 *
 *	couopn(telno, flds, dev) connect to courier
 *	char *flds[], *dev[];
 *
 *	return codes:
 *		>0  -  file number  -  ok
 *		CF_DIAL,CF_DEVICE  -  failed
 */

couopn(telno, flds, dev)
char *telno;
char *flds[];
struct Devices *dev;
{
	extern errno;
	char dcname[20];
	char cbuf[MAXPH];
	register char *cp;
	register int i;
	int dh = -1, rings;

	sprintf(dcname, "/dev/%s", dev->D_line);
	DEBUG(4, "dc - %s\n", dcname);
	if (setjmp(Sjbuf)) {
		logent(dcname, "TIMEOUT");
		if (dh >= 0)
			coucls(dh);
		return CF_DIAL;
	}
	signal(SIGALRM, alarmtr);
	getnextfd();
	alarm(10);
	dh = open(dcname, 2); /* read/write */
	alarm(0);

	/* modem is open */
	next_fd = -1;
	if (dh < 0) {
		logent(dcname, "CAN'T OPEN");
		return dh;
	}
/*
 *	always open at high speed and do the conversation there, we step
 *	down later if we need it anyway.
 */
	fixline(dh, DEFBAUD);

	if (dochat(dev, flds, dh)) {
		logent(dcname, "CHAT FAILED");
		coucls(dh);
		return CF_DIAL;
	}
/*
	write "at\r" to trailblazer, this forces it to the interface
	baud rate, given the modem's default settings there should be
	no return code so we don't need an expect after the write().
*/
/*	clear modems input buffers	*/
	write(dh, "\r", 1);
	sleep(1);
/*	make sure modem is at the same baud rate we are	*/
	write(dh, "atz\r", 4);
	sleep(1);
/*	init modem	*/
	write(dh, "atq0v0e0h0x6s0=0s2=255\r", 23);

	if (expect("0\r", dh) != 0) {
		logent(dcname, "Courier seems dead");
		coucls(dh);
		return CF_DIAL;
	}
	write(dh, "\ratd", 4);
	write(dh, telno, strlen(telno));
	write(dh, "\r", 1);

	if (setjmp(Sjbuf)) {
		logent(dcname, "TIMEOUT");
		strcpy(devSel, dev->D_line);
		coucls(dh);
		return CF_DIAL;
	}
	signal(SIGALRM, alarmtr);
	alarm(CTMOUTLS);
	rings = 0;
	do {
/*	read garbage characters in until a digit is found	*/
		cp = cbuf;
		while (read(dh, cp, 1) == 1)
			if (isdigit(*cp))
				break;
		++cp;

/*	read characters in so long as they are numeric	*/
		while (read(dh, cp++, 1) == 1)
			if (!isdigit(*cp))
				break;
		*cp = '\0';
		i = atoi(cbuf);

		switch (i)    {
			case 3:
				coucls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("no carrier"));
			case 4:
				coucls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("error"));
			case 6:
				coucls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("no dial tone"));
			case 7:
				coucls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("busy"));
			case 12:
				coucls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("voice"));
			case 11:
				DEBUG(4,"GOT: ringing\n", CNULL);
		}
	} while ((i == 11) && (++rings < 6));

	alarm(0);

	switch (i)    {
		case 3:
			i = 300;
			break;
		case 5:
			i = 1200;
			break;
		case 10:
			i = 2400;
			break;
		case 11:
/*	rung too many times, assume no answer will come	*/
			coucls(dh);
			strcpy(devSel, dev->D_line);
			return (FLog("no answer"));
		default:
/* probably don't need this but there is no overhead for it */
			coucls(dh);
			strcpy(devSel, dev->D_line);
			return (FLog(cbuf));
	}
	if (i != DEFBAUD)    {
		DEBUG(4,"Baudrate reset to %d\n", i);
		fixline(dh, i);
	}

	DEBUG(4, "courier connect at %d bps\n", i);
	return dh;
}

coucls(fd)
int fd;
{
	char dcname[20];
	
	struct sgttyb hup, sav;

	if (fd > 0) {
		sprintf(dcname, "/dev/%s", devSel);
		DEBUG(4, "Hanging up fd = %d\n", fd);

		/*
		 * code to drop DTR -- change to 0 baud then back to default.
		 */
		gtty(fd, &hup);
		gtty(fd, &sav);
		hup.sg_ispeed = hup.sg_ospeed = B0;
		stty(fd, &hup);
		sleep(2);
		stty(fd, &sav);
		write(fd, "atz\r", 4);
		sleep(1);
		write(fd, "ate0f1h0m0q1s2=255\r", 17);
		sleep(1);
		close(fd);
		delock(devSel);
	}
}

#endif COURIER
