#include "../condevs.h"
#include <ctype.h>

#ifdef TELEBIT

#define TBTMOUTHS 60	/* high speed timeout */
#define TBTMOUTLS 30	/* low speed timeout */
#define PEPBAUD 19200	/* interface speed for PEP connections */
/*
 *	to run uucico with this dialer I set the Trailblazer's registers
 *	as follows:

E0 F1 M1 Q1 T V1 X1     Version BA4.00
S00=001 S01=000 S02=255 S03=013 S04=010 S05=008 S06=002 S07=060 S08=002 S09=006
S10=007 S11=070 S12=050
S45=255 S47=004 S48=000 S49=000
S50=000 S51=005 S52=002 S53=003 S54=001 S55=000 S56=017 S57=019 S58=003 S59=000
S60=000 S61=000 S62=003 S63=001 S64=001 S65=000 S66=000 S67=000 S68=255
S90=000 S91=000 S92=001 S95=002
S100=000 S101=000 S102=000 S104=000
S110=001 S111=255 S112=001
S121=000
N0:
N1:
N2:
N3:
N4:
N5:
N6:
N7:
N8:
N9:

 *	tbopn(telno, flds, dev) connect to trailblazer
 *	char *flds[], *dev[];
 *
 *	return codes:
 *		>0  -  file number  -  ok
 *		CF_DIAL,CF_DEVICE  -  failed
 */

tbopn(telno, flds, dev)
char *telno;
char *flds[];
struct Devices *dev;
{
	extern errno;
	char dcname[20];
	char cbuf[MAXPH];
	register char *cp;
	register int i;
	int dh = -1, rings;

	sprintf(dcname, "/dev/%s", dev->D_line);
	DEBUG(4, "dc - %s\n", dcname);
	if (setjmp(Sjbuf)) {
		logent(dcname, "TIMEOUT");
		if (dh >= 0)
			tbcls(dh);
		return CF_DIAL;
	}
	signal(SIGALRM, alarmtr);
	getnextfd();
	alarm(10);
	dh = open(dcname, 2); /* read/write */
	alarm(0);

	/* modem is open */
	next_fd = -1;
	if (dh < 0) {
		logent(dcname, "CAN'T OPEN");
		return dh;
	}
/*
 *	always open at high speed and do the conversation there, we step
 *	down later if we need it anyway.
 */
	fixline(dh, PEPBAUD);

	if (dochat(dev, flds, dh)) {
		logent(dcname, "CHAT FAILED");
		tbcls(dh);
		return CF_DIAL;
	}
/*
	write "at\r" to trailblazer, this forces it to the interface
	baud rate, given the modem's default settings there should be
	no return code so we don't need an expect after the write().
*/
/*	clear modems input buffers	*/
	write(dh, "\r", 1);
	sleep(1);
/*	make sure modem is at the same baud rate we are	*/
	write(dh, "at\r", 3);
	sleep(1);
/*	init modem	*/
	if (dev->D_speed == PEPBAUD)
		write(dh, "atq6v0e0h0x1s7=60s50=255s51=5s54=4s111=30\r", 42);
	else
		write(dh, "atq6v0e0h0x1s7=30s50=0s51=5s54=4\r", 33);

	if (expect("0\r", dh) != 0) {
		logent(dcname, "TrailBlazer seems dead");
		tbcls(dh);
		return CF_DIAL;
	}
	write(dh, "\ratdt", 5);
	write(dh, telno, strlen(telno));
	write(dh, "\r", 1);

	if (setjmp(Sjbuf)) {
		logent(dcname, "TIMEOUT");
		strcpy(devSel, dev->D_line);
		tbcls(dh);
		return CF_DIAL;
	}
	signal(SIGALRM, alarmtr);

	if (dev->D_speed == PEPBAUD)
		alarm(TBTMOUTHS);
	else
		alarm(TBTMOUTLS);
	rings = 0;
	do {
/*	read garbage characters in until a digit is found	*/
		cp = cbuf;
		while (read(dh, cp, 1) == 1)
			if (isdigit(*cp))
				break;
		++cp;

/*	read characters in so long as they are numeric	*/
		while (read(dh, cp++, 1) == 1)
			if (!isdigit(*cp))
				break;
		*cp = '\0';
		i = atoi(cbuf);

		switch (i)    {
			case 2:
				tbcls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("ring"));
			case 3:
				tbcls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("no carrier"));
			case 4:
				tbcls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("error"));
			case 6:
				tbcls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("no dial tone"));
			case 7:
				tbcls(dh);
				strcpy(devSel, dev->D_line);
				return (FLog("busy"));
			case 52:
				DEBUG(4,"GOT: rring\n", CNULL);
		}
	} while ((i == 52) && (++rings < 6));

	alarm(0);

	switch (i)    {
		case 3:
			i = 300;
			break;
		case 5:
			i = 1200;
			break;
		case 10:
			i = 2400;
			break;
		case 50:
			i = 19200;
			break;
		case 52:
/*	rung too many times, assume no answer will come	*/
			tbcls(dh);
			strcpy(devSel, dev->D_line);
			return (FLog("no answer"));
		default:
/* probably don't need this but there is no overhead for it */
			tbcls(dh);
			strcpy(devSel, dev->D_line);
			return (FLog(cbuf));
	}
	if (i != PEPBAUD)    {
		DEBUG(4,"Baudrate reset to %d\n", i);
		fixline(dh, i);
	}

	DEBUG(4, "telebit connect at %d bps\n", i);
	return dh;
}

tbcls(fd)
int fd;
{
	char dcname[20];
	
	struct sgttyb hup, sav;

	if (fd > 0) {
		sprintf(dcname, "/dev/%s", devSel);
		DEBUG(4, "Hanging up fd = %d\n", fd);

		/*
		 * code to drop DTR -- change to 0 baud then back to default.
		 */
		gtty(fd, &hup);
		gtty(fd, &sav);
		hup.sg_ispeed = hup.sg_ospeed = B0;
		stty(fd, &hup);
		sleep(2);
		stty(fd, &sav);
		close(fd);
		delock(devSel);
	}
}

FLog(str)
char *str;
{
	DEBUG(4,"\nGOT: %s\n", str);
	logent(str, _FAILED);
	return CF_DIAL;
}
#endif TELEBIT
