/*
 * Stuff to work out when to next change state (causes exit)
 * and whether to apply a particular bit of the modem conversation.
 */
 
#include <time.h>

#include "modem.h"
#ifdef STATES

#define	SECS_IN_WEEK		(60L * 60L * 24L * 7L)
#define WEEK_TIME(d,h,m)	((((long)d*24L+(long)h)*60L+(long)m)*60L)
#define EVENT_LEN		(sizeof(week_event)/sizeof(struct event))
#define IND_LEN			(sizeof(ind_tab)/sizeof(struct ind))

/*
	This is a table of when to turn on and off the autoanswer mode
	of the modem.
*/
struct event {
	long s_time;
	int s_state;
} week_event[] = {
   	{ WEEK_TIME (0,  7, 35), AA | SPK }, /* AA on, speaker on   7:35 Sun */
   	{ WEEK_TIME (0, 22, 00), AA },       /* AA on, speaker off 22:00 Sun */
	{ WEEK_TIME (1,  7, 35), SPK },      /* AA off, speaker on  7:35 Mon */
   	{ WEEK_TIME (1, 17, 25), AA | SPK }, /* AA on, speaker on  17:25 Mon */
   	{ WEEK_TIME (1, 22, 00), AA },       /* AA on, speaker off 22:00 Mon */
	{ WEEK_TIME (2,  7, 35), SPK },      /* AA off, speaker on  7:35 Tue */
   	{ WEEK_TIME (2, 17, 25), AA | SPK }, /* AA on, speaker on  17:25 Tue */
   	{ WEEK_TIME (2, 22, 00), AA },       /* AA on, speaker off 22:00 Tue */
	{ WEEK_TIME (3,  7, 35), SPK },      /* AA off, speaker on  7:35 Wed */
   	{ WEEK_TIME (3, 17, 25), AA | SPK }, /* AA on, speaker on  17:25 Wed */
   	{ WEEK_TIME (3, 22, 00), AA },       /* AA on, speaker off 22:00 Wed */
	{ WEEK_TIME (4,  7, 35), SPK },      /* AA off, speaker on  7:35 Thu */
   	{ WEEK_TIME (4, 17, 25), AA | SPK }, /* AA on, speaker on  17:25 Thu */
   	{ WEEK_TIME (4, 22, 00), AA },       /* AA on, speaker off 22:00 Thu */
	{ WEEK_TIME (5,  7, 35), SPK },      /* AA off, speaker on  7:35 Fri */
   	{ WEEK_TIME (5, 17, 25), AA | SPK }, /* AA on, speaker on  17:25 Fri */
   	{ WEEK_TIME (5, 22, 00), AA },       /* AA on, speaker off 22:00 Fri */
   	{ WEEK_TIME (6,  7, 35), AA | SPK }, /* AA on, speaker on   7:35 Sat */
   	{ WEEK_TIME (6, 22, 00), AA }        /* AA on, speaker off 22:00 Sat */
};

long duration(state)
int *state;			/* 0 if new Auto Answer state is OFF, 1 if ON */
{
	long secs_into_week;	/* Seconds since midnight Sunday morning */
	long t;
	struct tm *cur_time;
	int i, index;
	long delta, tst_delta;

	t = time((long *) 0);
	cur_time = localtime (&t);

	secs_into_week = ((((long)(cur_time->tm_wday)) * 24L + 
		(long)(cur_time->tm_hour)) * 60L +
		(long)(cur_time->tm_min)) * 60L + 
		(long)(cur_time->tm_sec);

	delta = SECS_IN_WEEK + 1; /* SOMETHING has to be closer than this! */

	/* Loop looking for an entry with a better delta (closer to now) */

	for (i=0; i < EVENT_LEN; i++) {
		tst_delta = week_event[i].s_time - secs_into_week;
		if (tst_delta < 0L)
			tst_delta += SECS_IN_WEEK; /* Adjust for wrap around */
		if (tst_delta < delta) {
			/* We found a closer event to now */
			delta = tst_delta;
			index = i;
		}
	}
	/*
	 * Decrement index by one circularly (note table MUST be in order) --
	 */
	if (index-- == 0)
		index = EVENT_LEN-1;
	*state = week_event[index].s_state;
#ifdef DEBUG
	printf("Currently in state %d.  Will change in %ld seconds\n",
		*state, delta);
#endif
	return(delta);
}

/*
	This routine decides whether a particular init line should be executed.
*/
applicable(p, state)
struct conv *p;
int state;
{
	return(p->c_flags & state);
}

#endif
