/*
 * some constants for your modem
 */
 
#define TIMEZONE "TZ=GMT0BST"		/* time zone you operate in	*/
#define DEFSPEED "1200"			/* speed your modem likes most	*/

#define WTIME 5				/* default wait time 		*/

#define LOGFILE "/usr/spool/uucp/modem.log"		/* log file */

#define max(a,b) ((a) > (b) ? (a) : (b))
#define min(a,b) ((a) < (b) ? (a) : (b))

#define MINUTES	60
#define IDLETIME 5*MINUTES				/* autologout time */
#ifdef WATCHIT
#define SPYTIME 1*MINUTES
#else
#define SPYTIME IDLETIME
#endif

#define GRACETIME	5	/* time to wait for signal to take effect */

extern int errno;

#ifdef MAINDEF
#define EXTERN
#else
#define EXTERN extern
#endif

long time();
int dread(), dwrite(), myread();
void mywrite();

EXTERN char lockf[50];				/* argument lock file */
EXTERN char dname[30];				/* device name in full - /dev/.... */

EXTERN int shell, status;			/* pid of shell, and exit status */

EXTERN int dev;					/* device used (open fildes) */
/*
 * The 'reset' sequence, if the modem doesn't behave as expected.
 * I still get problems with the modem not responding to 'AT'.
 */
#if defined(HAYES)
#define RESET "\n\rAT\r\rAT\r\rAT\r\r"
#else
#define RESET ""
#endif
/*
 * The 'conversation' necessary to get your modem into a 'listening' state.
 * The converasation should complete iff an incoming call is connected.
 * If using Jack's states, set up your states below. Each modem line
 * must have flags set to indicate in which state(s) it can be executed.
 * If you're not using the STATES stuff, leave them at zero.
 */
#define SPK			0x0001	/* Speaker control */
#define	AA			0x0002	/* Auto Answer Control */

struct conv {
	char *c_send;
	char *c_expect;
	int c_wait;		/* time to wait for c_expect */
	int c_flags;		/* flags for matching with the state. */
};

#ifdef MAINDEF

struct conv ring[] = {

#if defined(HAYES)
	{"AT\r", "OK", WTIME, AA | SPK },	/* anyone there? */
	{"ATM0\r", "OK", WTIME, AA | SPK },	/* turn OFF speaker */
	{"ATS0=0\r", "OK", WTIME, AA | SPK},	/* DISABLE auto-answer */
	{"ATS0=1\r", "OK", WTIME, AA},		/* maybe enable auto answer */
	{"ATM1\r", "OK", WTIME, SPK},		/* maybe turn speaker on */
	{"ATX1V1\r", "OK", WTIME, AA | SPK },	/* turn on responses */ 
	{"ATS24=3\r", "OK", WTIME, AA | SPK},	/* enable speed-seeking */
	{"", "RING", 0, AA | SPK},		/* wait (indefinately) for RING in */
	{"", "CONNECT", 20, AA | SPK},		/* wait for call to be connected */
	{NULL, NULL, 0, 0}			/* finished */

#else /* defined (HAYES) */
#if defined(JSET)	/* AT&T Aztec Protocol */
	{"\\d\r\\d", "MODEM: ", WTIME, 0 },	/* anyone there? */
	{"", "DATA", 3600, 0},		/* wait (1 hour) for RING in */
	{NULL, NULL, 0, 0}			/* Should be indefinite, but prevent
					   problems if modem gets wedged */

#else /* defined (JSET) */
	{NULL, NULL, 0, 0}			/* no init conversation */

#endif /* defined (JSET) */
#endif /* defined (HAYES) */
};
#endif /* defined (MAINDEF) */
