/*
 * Copyright (c) Dave Settle, Mar 1987
 * Permission is granted to do anything with this program, except remove
 * this copyright notice, or sell it for profit.
 *
 *
 * change the ut_pid value from "old" to "new".
 * Attempts to do all the things that "getty" appears to do.
 */
 
#include <sys/types.h>
#include <utmp.h>

struct utmp *utmp, *getutent();

uchange(old, new)
{
	setutent();
	while(utmp = getutent()) {
		if(utmp->ut_pid == old) {
			utmp->ut_pid = new;
			if(strcmp(utmp->ut_user, "getty")) 
				strcpy(utmp->ut_user, "modem");
			else
				strcpy(utmp->ut_user, "getty");
			pututline(utmp);
			endutent();
			return(1);
		}
	}
	printf("Can't find utmp entry\n");
	endutent();
	return(1);
}

