/*
 * Copyright (c) Dave Settle, Mar 1987
 * Permission is granted to do anything with this program, except remove
 * this copyright notice, or sell it for profit.
 *
 *
 * sendex.c: contains the send-expect routines, beefed-up a little to
 * make them more useful.
 * Both "send" and "expect" now have a function, rather than
 * a file descriptor. This function gets called as follows:
 *
 *	(int) (*rdfunc)();		[send]
 *	(*wtfunc)((char *)s);		[expect]
 *
 */

#include <setjmp.h>
#include <signal.h>
#include <stdio.h>
/*
 * send: write the string out. Show the chars written if necessary.
 */
send(s, func)
char *s;
void (*func)();
{
#ifdef	DEBUG
	printf("send(");
	sshow(s);
	printf(")\n");
#endif
	(*func)(s);
	sleep(1);
}
/*
 * expect: expect a string. Return 0 on success, 1 on timeout.
 * chars are threaded on the needle as they match the expect string
 * if one fails to match, all chars are unthreaded. 
 * expect succeeds if all chars on expect string are threaded.
 */
jmp_buf env;

timeout(){
	longjmp(env, 1);
}

expect(s, t, func)
char *s;
int (*func)();
{
	char *needle = s, c;
	int (*handler)();
	alarm(0);
	handler = signal(SIGALRM, timeout);
	if(setjmp(env)) {
		printf("Timeout expecting %s\n", s);
		return(1);		/* fail - timeout */
	}
	alarm(t);				/* if zero, no timeout */
#ifdef	DEBUG
	printf("\nexpect(%s)\n", s);
#endif
	while(*needle) {
		c = (*func)();
#ifdef DEBUG
		show(c);
#endif
		if(*needle != c) needle = s;
		if(*needle == c) needle++;
	}
#ifdef	DEBUG
	printf("got it\n");
#endif
	alarm(0);
	signal(SIGALRM, handler);
	return(0);
}
#ifdef	DEBUG
/*
 * sshow: show string
 */
sshow(s)
char *s;
{
	while(*s) show(*s++);
}
show(c)
char c;
{
	if((c < 31)) {
		printf("^%c", c + '@');
		if(c == '\n') putchar('\n');
	}
	else putchar(c);
	fflush(stdout);
}
#endif

