/*
 * line.c: set up the various termio params for the line at various stages.
 * [What I would like for Christmas: System V tty driver code, so I could
 *  find out why it behaves so strangely ... ]
 */
 
#include "modem.h"
#include <termio.h>
#include <fcntl.h>

static struct termio term;
static int speed;

init_term(device, baud)
int device, baud;
{
	speed = baud;
	if(ioctl(device, TCGETA, &term) == -1) perror("TCGETA");
	term.c_lflag &= ~(ICANON | ECHO | ECHOE | ECHOK);
	term.c_iflag &= ~(ISTRIP | INPCK);
	term.c_cflag &= ~(CBAUD | CSIZE);
	term.c_cflag |= baud | CS8 | CLOCAL;
	term.c_cc[VMIN] = 1;
	term.c_cc[VTIME] = 0;
 	if(ioctl(device, TCSETA, &term) == -1) perror("TCSETA");
/*
 * Since we opened the line with O_NDELAY, reads will return immediately if
 * no chars are ready. We don't really want this, 'cos "dread" will then
 * eat CPU time, so we turn it off.
 * It only seems to be really effective when the device is opened again -
 * otherwise we get strange diagnostics about "wrote 0 of 4". Thanks to
 * the C-KERMIT crew for this tip.
 *
 * The open() here seems to hang sometimes, so a timeout is implemented.
 * [since CLOCAL has been set above, this should never happen. We can't
 *  just open with O_NDELAY, because uucp won't work anyway.]
 */
 	fcntl(device, F_SETFL, 0);
 	alarm(5);
 	if(close(open(dname, O_RDONLY)) == -1 ) {
 		printf("** Error: Couldn't reopen device after TCSETA\n");
 		exit(1);
 	}
 	alarm(0);
}
/*
 * Strange things have been known to happen during "login" with incorrect 
 * settings - if it forgets to ask you for a password, check them carefully.
 * Oct 87: Disable CLOCAL, since DCD is now asserted, and we want to be told
 * about hangups.
 */
login_term(device, baud)
int device, baud;
{
	ioctl(device, TCGETA, &term);
	term.c_cc[VEOF] = 04;		/* cntrl-D */
	term.c_iflag = BRKINT | IGNPAR | ISTRIP | ICRNL;
	term.c_oflag = OPOST | ONLCR | TAB3;
	term.c_cflag &= ~(CSIZE | CLOCAL | CBAUD);
	term.c_cflag |= CS7 | HUPCL | CREAD | baud;
	term.c_lflag = ISIG | ICANON;
	ioctl(device, TCSETAW, &term);
}
/*
 * fixline: write failed - redo settings on line.
 */
fixline(){
	ioctl(dev, TCFLSH, 2);		/* flush queues */
	ioctl(dev, TCXONC, 1);		/* restart XON/XOFF */
	fcntl(dev, F_SETFL, 0);		/* poke the flag */
	close(open(dname, O_RDONLY | O_NDELAY));
	init_term(dev, speed);
}
	
