#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Spool Usenet news articles to fidonet. Currently there is no news-system
   in fido, it's done by software after and before mail-slots. Echomail
   is most popular one, and this program does about the same thing:
   it sends news-articles as fido-mail containing suitable information
   for echomail. Echomail relies on normal fido-mail, we send news thru
   rfmail, because this mechanism requires nothing different from normal
   mail.

   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "fnews.h"
#include "nodelist.h"

extern void exit();
extern void perror();

int verbose = INIT_VERBOSE;

/* Get header field. Rewind header file and scan forward until we find
   desired field. Not effective, but... Return NULL if field not found. */

char *
get_field(field, hdr)
     char *field;
     FILE *hdr;
{
  static char buffer[BUFLEN];
  int conditional = FALSE;
  char *p;

  if (*field == '?')
    {
      conditional = TRUE;
      for (p = field; *p = *(p + 1); p++);
    }

  (void) rewind(hdr);
  while (fgets(buffer, BUFLEN, hdr))
    if (!strncmp(field, buffer, strlen(field)))
      {
    if (conditional)
      {
        /* Note: <= is ok, because there is one blank after header which
           wouldn't be included in Fidonet message header */
        if (!strncmp(field, "Subject:", 8))
          if (strlen(buffer + 8) <= 72) return NULL;
        if (!strncmp(field, "From:", 5))
          if (strlen(buffer + 5) <= 36) return NULL;
        if (!strncmp(field, "Reply-To:", 9))
          if (strlen(buffer + 9) <= 36) return NULL;
        if (!strncmp(field, "To:", 3))
          if (strlen(buffer + 3) <= 36) return NULL;
      }

        buffer[strlen(buffer) - 1] = 0;
        return buffer + strlen(field);
      }

  return (char *) NULL;
}

/* Open stream which is associated with fido-mailers starndard input.
   We could use also popen(3S), but it invokes also sh(1) which slows
   down opening and gets more memory. This routine exists if something
   goes wrong, because this is quite essential part of program and
   we can not continue without mailer. */

FILE *
open_mailer(to)
     char *to;
{
  FILE *fp;
  int fd[2];
  char mailer[128];

  (void) sprintf(mailer, "%s/rfmail", LIBDIR);

  /* create pipe */
  if (pipe(fd) == -1)
    {
      perror("rfnews: pipe");
      exit(1);
    }

  switch (fork())
    {
    case -1:
      perror("rfnews: fork failed");
      exit(1);
    case 0:
      (void) close(0);
      /* duplicate pipe and close now unused fd's */
      if (dup(fd[0]) == 0)
        {
          (void) close(fd[0]);
          (void) close(fd[1]);
          (void) execlp(mailer, "rfmail", "-p", to, (char *) NULL);
          perror(mailer);
        }
      else
        perror("rfnews: dup");
      exit(0);
    default:
      (void) close(fd[0]);
      /* open the other end of pipe as buffered */
      if ((fp = fdopen(fd[1], "w")) == NULL)
        {
          perror("rfnews: fdopen");
          exit(1);
        }
    }
  return fp;
}

/* Save news header for future processing and return file pointer to it. */

FILE *
save_hdr()
{
  char buffer[BUFLEN];
  FILE *hdr = tmpfile();

  while (fgets(buffer, BUFLEN, stdin) && *buffer != '\n')
    (void) fputs(buffer, hdr);
  return hdr;
}

/* Open rfmail. Send mail to net/node in config file, receiver will be
   All, because Usenet News articles don't have To: field. Net/node
   exraction is not very reliable of there's something wrong in
   configuration file. */

FILE *
invoke_rfmail(config)
     FILE *config;
{
  char buffer[BUFLEN], *cp;
  int net, node;

  section(SECT_NETNODE, config);
  if (getcl(buffer, BUFLEN, config))
    {
      /* get net number */
      for (cp = buffer, net = 0; *cp && isdigit(*cp) && *cp != '/'; cp++)
        net = net * 10 + *cp - '0';
      debug(1, "Got net %d from config file", net);
      if (*cp)
        {
          /* get node number */
          for (cp++, node = 0; *cp && isdigit(*cp); cp++)
            node = node * 10 + *cp - '0';
          debug(1, "Got node %d from config file", node);
        }
      else
        {
          log("Missing node in config file");
          exit(1);
        }
      (void) sprintf(buffer, "All@%d.%d.FidoNet", node, net);
      return open_mailer(buffer);
    }
  else
    {
      log("Missing net/node in config file");
      exit(1);
    }
  /* NOTREACHED */
}

/* Try to get area for some of the newsgroups in newsgroup list. Method
   is not very sophisticated, but it should work. */

char *
get_area(config, groups)
     FILE *config;
     char *groups;
{
  static char conv[BUFLEN];
  char buffer[BUFLEN];
  char *cp, *gr, *area;

  debug(2, "Checking grouplist '%s'", groups);

  section(SECT_NG_AREA, config);
  while (getcl(conv, BUFLEN, config))
    {
      for (cp = conv; !isspace(*cp); cp++)
        /* find the end of newsgroup name */;
      if (isspace(*cp))
        {
          *cp++ = 0;
          (void) strcpy(buffer, groups);
          debug(3, "Config line '%s'", conv);
          /* get group by group from newsgroup-list */
          for (gr = strtok(buffer, " ,"); gr; gr = strtok((char *) NULL, " ,"))
            {
              debug(3, "Comparing '%s' and '%s'", gr, conv);
              if (!strcmp(gr, conv))
                {
                  while (isspace(*cp))
                    cp++;
                  area = cp;
                  while (*cp && !isspace(*cp))
                    cp++;
                  *cp = 0;
                  debug(3, "Match, return area '%s'", area);
                  return area;
                }
            }
          debug(3, "No match");
        }
      else
        log("Invalid line in config: '%s'", conv);
    }
  log("No area found for any group in '%s'", groups);
  return (char *) NULL;
}

/* Do actual processing of article. This will copy article, get newsgoroups
   and save them and then send all rest of article. */

/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  FILE *config, *rfmail, *hdr;
  char buffer[BUFLEN], seenbys[BUFLEN];
  int c;
  char *cp, *errorstr;

  /* get options */
  while ((c = getopt(argc, argv, "v")) != EOF)
    switch (c)
      {
      case 'v':
        verbose++;
        break;
      default:
        (void) fprintf(stderr, "Usage: %s [-v]\n", *argv);
        exit(1);
      }

  /* try to update nodelist-index */
  if (errorstr = update_index())
    {
      if (*errorstr == '$')
        log("$Cannot update nodelist-index: %s", errorstr + 1);
      else
        log("Cannot update nodelist-index: %s", errorstr);
      exit(EX_OSERR);
    }

  /* try to open config file */
  if ((config = pfopen(LIBDIR, "fnews.cf", "r")) == NULL)
    {
      log("$Unable to open config file");
      exit(1);
    }

  /* open rfmail to send news */
  rfmail = invoke_rfmail(config);

  /* save news header */
  hdr = save_hdr();

  /* try to get area to which this article is going */
  if (cp = get_field("Newsgroups: ", hdr))
    if (cp = get_area(config, cp))
      {
    (void) fprintf(rfmail, "AREA:%s\n", cp);
    debug(2, "send area %s", cp);
      }
    else
      {
        log("Unable to get area");
#ifdef JUNK_AREA
        (void) fprintf(rfmail, "AREA:\n", JUNK_AREA);
        log("Sending article to area %s", JUNK_AREA);
#else
        exit(1);
#endif
      }
  else
    {
      log("Missing Newsgroups: line in article");
      exit(1);
    }

  /* now send news header */
  section(SECT_HEADERS, config);
  while (getcl(buffer, BUFLEN, config))
    if (cp = get_field(buffer, hdr))
      (void) fprintf(rfmail,"%s%s\n", buffer, cp);
  (void) putc('\n', rfmail);

  /* send rest of the article */
  while (fgets(buffer, BUFLEN, stdin))
    (void) fputs(buffer, rfmail);

  /* send last information */
  fprintf(rfmail, "--- %s\n", PROGRAMNAME);
  section(SECT_ENDMSG, config);
  if (!getcl(buffer, BUFLEN, config))
    strcpy(buffer, "No Origin");
  else if (!getcl(seenbys, BUFLEN, config))
    *seenbys = 0;

  (void) fprintf(rfmail, " * Origin: %s (%d:%d/%d.%d)\n", buffer,
         MY_ZONE, MY_NET, MY_NODE, MY_POINT);
  fprintf(rfmail, "SEEN-BY: %s \n", seenbys);
  fprintf(rfmail, "\001PATH: %d/%d \n", MY_NET, MY_NODE);

  /* I think that that was all... */
  (void) fclose(rfmail);
  (void) wait((int *) NULL);

  exit(0);
  /* NOTREACHED */
}
