/* @(#)%M%  %I%  Teemu Torma %H%

   Structures and definitions for nodelist.

   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* Change these if you wish. */

/* Name of nodelist in LIBDIR */
#define NODELIST "nodelist"

/* Name of nodelist index file in LIBDIR */
#define INODELIST "nodelist.idx"

/* Name of sysop name index file in LIBDIR */
#define NAMELIST "name.idx"

/* Compare two node entried to see if they are same node (ignoring
   possible other information */
#define samenode(n1, n2) ((n1).zone == (n2).zone && (n1).net == (n2).net && \
              (n1).node == (n2).node && (n1).point == (n2).point)

/* Structure for nodelist entry. Routines to get one node from nodelist
   will return this structure. */

typedef struct _node {
  int type; /* type of entry (see below) */
  int region; /* region (not necessarily used/set) */
  int net; /* net/region of node */
  int zone; /* Zone of node (not really supported yet) */
  int node; /* number of node */
  int point; /* Point of node (not really supported yet) */
  char name[20]; /* name of fido */
  char city[40]; /* city */
  char sysop[36]; /* name of sysop */
  char phone[40]; /* phone-number */
  int speed; /* speeds */
  char flags[60]; /* flags-string */
} Node;

typedef struct _indexnode {
  int zone;
  int net;
  int node;
  long offset;
} NODEINDEX;

typedef struct _indexname {
  char name[36]; /* Sysop name */
  long offset; /* Refers to nodelist index entry */
  int zone;
  int net;
} NAMEINDEX;

/* Entry types. */

#define REGION (1) /* region-host */
#define HOST (2) /* net-host */
#define HUB (3) /* local-host */
#define PVT (4) /* private node */
#define HOLD (5) /* no mail to this node */
#define DOWN (6) /* node is down */
#define KENL (7) /* should not be comminucated */
#define NORMAL (8) /* normal node */
#define ZONE (9) /* Zone */
#define POINT (10) /* point (points are not in nodelist but this is used
              elsewhere. */

/* Declarations for routines. */

Node *node_entry(); /* get entry from nodelist */
char *update_index(); /* update index-file */
extern Node *parse_entry();

extern Node originnode;
extern NODEINDEX *nodeindex;
extern NAMEINDEX *nameindex;
extern int nodes;
