#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Dial to host-fido for mail.

   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <signal.h>
#include <termio.h>
#include <dial.h>
#include <sys/types.h>
#include <dirent.h>
#include <time.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "fio.h"
#include "nodelist.h"

extern unsigned sleep();
extern void exit();
extern int getopt();
extern int optind;
extern char *optarg;

int line = -1;
int verbose = INIT_VERBOSE;

/* Macros to check timeout */

#define SetStart() (stime = time((long *) 0))
#define Timeout(t) (time((long *) 0) - stime > (t))

/* States for session sender. */

#define SendInit        (0)
#define WaitCxD         (1)
#define WhackCRs        (2)
#define WaitClear       (3)
#define SendMail        (4)
#define CheckMail       (5)
#define SendFiles       (6)
#define CheckFiles      (7)
#define TryPickup       (8)

/* States for session receiver. */

#define WaitTsync       (9)
#define RecMail         (10)
#define XRecEnd         (11)
#define RecFiles        (12)
#define ChkFiles        (13)
#define AllowPickup     (14)

/* States to break up the loops */

#define Error           (-1)
#define Done            (-2)

/* For debugging */

static char devicebuffer[100];
CALL call; /* call structure for dial(3) */

/* Show dialer's error code as message */

void
log_dialerr(code)
     int code;
{
  switch (code)
    {
    case INTRPT:
      log("Interrupt occured during dialing");
      break;
    case D_HUNG:
      log("Dialer hung (no return from write)");
      break;
    case NO_ANS:
      log("No answer");
      break;
    case ILL_BD:
      log("Illegal baud-rate");
      break;
    case A_PROB:
      log("Acu problem (open() failure)");
      break;
    case L_PROB:
      log("Line problem (open() failure)");
      break;
    case NO_Ldv:
      log("Can't open LDEVS file");
      break;
    case DV_NT_A:
      log("Requested device not available");
      break;
    case DV_NT_K:
      log("Requested device %s, line %s telno %s speed %d baud %d, not known",
      call.device, call.line, call.telno, call.speed, call.baud);
      break;
    case NO_BD_A:
      log("No device available at requested baud");
      break;
    case NO_BD_K:
      log("No device known at requested baud");
      break;
    case DV_NT_E:
      log("Requested speed does not match");
      break;
    default:
      log("Dial error %d", code);
    }
}

/* Trapper for signals to quit gracefully. Be must do undial to get lock-
   file removed */

int
quit(sig)
     int sig;
{
  (void) signal(SIGINT, SIG_IGN);
  (void) signal(SIGQUIT, SIG_IGN);
  (void) signal(SIGTERM, SIG_IGN);
  (void) signal(SIGHUP, SIG_IGN);

  if (line >= 0)
    undial(line);
  if (sig >= 0)
    log("Caught signal %d", sig);
  exit(1);
  /* NOTREACHED */
}

/* Send files in batch protocol */

bool
sendfiles()
{
/*   if (batchsend("fio.h")) */
  return batchsend((char *) 0);
/*   else return 0; */
}

bool recfiles()
{
  return batchrec((char *) 0);
}

/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  struct termio tio; /* terminal state */
  int c;
  time_t stime;
  int retry_time = 0, no_retrys = 0, wait_line = 0;
  int state = SendInit, receive_retrys = MAX_SEND_RETRIES;
  bool ok, pickup = False;
  Node *node, tnode;
  char phonenumber[100];
  char packetname[100], ipacketname[100];
  char *error, *p;

  /* try to update nodelist-index */
  if (error = update_index())
    {
      if (*error == '$')
        log("$Cannot update nodelist-index: %s", error + 1);
      else
        log("Cannot update nodelist-index: %s", error);
      exit(EX_OSERR);
    }

  if (chdir(SPOOL) < 0)
    {
      log("$Can not chdir to %s", SPOOL);
      exit(1);
    }

  strcpy(packetname, "packet.out");
  strcpy(ipacketname, "packet.junk");

  call.attr = &tio;
  call.baud = 0;
  call.speed = 0;
  call.line = NULL;
  call.telno = NULL;
  call.modem = 0;
  call.device = devicebuffer;
  call.dev_len = sizeof(devicebuffer);

  tio.c_iflag = IGNPAR | IGNBRK;
  tio.c_oflag = 0;
  tio.c_cflag = CS8 | CREAD | HUPCL | CLOCAL;
  tio.c_lflag = NOFLSH;
  tio.c_cc[VMIN] = 1;
  tio.c_cc[VTIME] = 0;

  if (signal(SIGINT, SIG_IGN) != SIG_IGN)
    (void) signal(SIGINT, quit);
  if (signal(SIGTERM, SIG_IGN) != SIG_IGN)
    (void) signal(SIGTERM, quit);
  if (signal(SIGQUIT, SIG_IGN) != SIG_IGN)
    (void) signal(SIGQUIT, quit);
  if (signal(SIGHUP, SIG_IGN) != SIG_IGN)
    (void) signal(SIGHUP, quit);

  while ((c = getopt(argc, argv, "vmdp:l:b:s:r:n:w:f:")) != EOF)
    switch (c)
      {
       case 'd':
        pickup = True;
        break;
       case 'p':
    call.telno = optarg;
    break;
      case 'v':
        verbose++;
        break;
      case 'l':
        call.line = optarg;
        break;
      case 'b':
        call.baud = atoi(optarg);
        break;
      case 's':
        call.speed = atoi(optarg);
        break;
      case 'r':
        retry_time = atoi(optarg);
        break;
      case 'n':
        no_retrys = atoi(optarg);
        break;
      case 'w':
        wait_line = atoi(optarg);
        break;
       case 'm':
    call.modem = 1;
    break;
       case 'f':

    /* Fidonet address to call */

    if (parsefnetaddress(optarg, &tnode)) exit(1);
    if (!(node = node_entry(tnode))) {
      log("Could not get node information");
      exit(1);
    }

    /* Use either maximum speed set or maximum speed of fido system */

    if (node->speed > MAXBAUD) {
      if (!call.baud) {
        call.baud = call.speed = MAXBAUD;
      }
    } else {
      call.baud = call.speed = node->speed;
    }
    if (call.baud < MINBAUD) call.baud = call.speed = MINBAUD;

    /* Translate phone number from nodelist, if not set */

    if (!call.telno) {
      dial_translation(phonenumber, node->phone);
      call.telno = phonenumber;
    }

    sprintpacketname(packetname, *node);
    sprintipacketname(ipacketname, *node);
    break;

       default:
        log("Illegal option for fcall");
        exit(1);
      }

  while (state >= SendInit && state < AllowPickup)
    switch (state)
      {
      case SendInit:
        if (call.telno)
          log("Dialing to %s", call.telno);
        line = dial(call);
        state = WaitCxD;
        break;
      case WaitCxD:
        if (line == NO_ANS && retry_time)
          if (--no_retrys < 0)
            {
              log("Too many retries in call");
              state = Error;
            }
          else
            {
              log("No answer, redial in %d seconds", retry_time);
              (void) sleep((unsigned) retry_time);
              state = SendInit;
            }
        else
          if ((line == DV_NT_A || line == NO_BD_A) && wait_line)
            {
              log("No free lines, waiting %d seconds", wait_line);
              (void) sleep((unsigned) wait_line);
            }
          else {
            if (line >= 0)
              {
                log("Call succeeded");
                state = WhackCRs;
                debug(1, "Wait %d seconds before start", PREWAIT);
                (void) sleep((unsigned) PREWAIT);
              }
            else
              {
                log_dialerr(line);
                log("Dial failed");
                state = Error;
              }
          }
        break;
      case WhackCRs:
        SetStart();
        while (state == WhackCRs)
          if (Timeout(30))
            {
              log("No response");
              state = Error;
            }
          else if (readline(1) == '\r')
            {
              debug(1, "Got CR, wait 1 second");
              (void) sleep((unsigned) 1);
              state = WaitClear;
            }
          else
            {
              debug(2, "Sending <sp><cr>");
              sendline(' ');
          sendline('\r');
            }
        break;
       case WaitTsync:
    SetStart();
    while (state == WaitTsync)
      if (Timeout(60))
        {
          log("Garbage, no Tsync, Call ok (?)");
          state = AllowPickup;
        }
      else if ((c = readline(1)) == TSYNCH)
        {
          debug(1, "Received TSYNCH");
          state = RecMail;
        }
      else if (c == ENQ)
        {
          debug(1, "Got ENQ, nothing to pick up");
          state = AllowPickup;
        }
    break;
       case RecMail:
    ok = xtrec(sprintfs("in/%s", ipacketname), False);
    state = XRecEnd;
    break;
       case XRecEnd:
    if (ok)
      {
        log("Mail received successfully");

        /* Flush input */

        (void) sleep((unsigned) 1);

        SetStart();
        while (state == XRecEnd)
          if (Timeout(60))
        {
          log("Garbage on line");
          state = Error;
          break;
        }
          else if (readline(1) == TIMEOUT)
        {
          debug(1, "Line is clear, rec files");
          state = RecFiles;
        }
      }
    else
      {
        log("Receiving mail failed or nothing to receive");
        log("Moving received packet in/%s to %s", ipacketname,
        p = sprintfs("%s/%s", BADARTICLES, ipacketname));
        if (link(sprintfs("in/%s", ipacketname), p))
          log("$Could not link packet in/%s", ipacketname);
        else
          if (unlink(sprintfs("in/%s", ipacketname)))
        log("$Could not unlink packet in/%s", ipacketname);

        state = Error;
      }
    break;
       case RecFiles:
    ok = recfiles();
    state = ChkFiles;
    break;
       case ChkFiles:
    if (ok)
      {
        log("Files received succesfully");
        (void) sleep((unsigned) 2);
        state = AllowPickup;
      }
    else
      {
        log("Files not received ok");
        state = Error;
      }
    break;
      case WaitClear:
        SetStart();
        while (state == WaitClear)
          if (Timeout(60))
            {
              log("Garbage on line");
              state = Error;
              break;
            }
          else if (readline(WAITCLEAR) == TIMEOUT)
            {
              debug(1, "Line is clear, send TSYNCH");
              sendline(TSYNCH);
          clear_input();
              state = SendMail;
            }
        break;
      case SendMail:
        ok = xtsend(sprintfs("out/%s", packetname), False);
    if (!ok && receive_retrys--)
      state = WaitClear;
    else
      state = CheckMail;

        break;
      case CheckMail:
        if (ok)
          {
            log("Mail sent successfully");
        log("Moving mail packet out/%s to %s", packetname,
        p = sprintfs("%s/%s.%s", SENTBUNDLE_DIR, packetname,
        baseit(sequencer(OPACKETSEQUENCE))));
        if (link(sprintfs("out/%s", packetname), p))
          log("$Could not link packet out/%s", packetname);
        else
          if (unlink(sprintfs("out/%s", packetname)))
        log("$Could not unlink packet out/%s",packetname);

        sequencer(OPACKETSEQUENCE);
            state = SendFiles;
          }
        else
          {
            log("Mail send failed");
            state = Error;
          }
        break;
      case SendFiles:
        ok = sendfiles();
        state = CheckFiles;
        break;
      case CheckFiles:
        if (ok)
          {
            log("Files sent successfully");
            state = TryPickup;
          }
        else
          {
            log("Files not send ok");
            state = Error;
          }
        break;
      case TryPickup:
        log("Send successful");
        if (pickup)
          {
            log("Starting mail pickup");
            state = WaitTsync;
          }
        else
          state = Done;
        break;
      }

  if (state == Error) {
    log("Conversation failed");
  } else {
    log("Conversation complete");
  }

  if (line >= 0) {
    (void) sleep((unsigned) 5);
    undial(line);
  }
  exit(0);
  /* NOTREACHED */
}
