#ifndef lint
static    char    *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Routines to handle fidonet addresses. Currently addres format in outside
   fidonet is <name>@<node>.<net>.fidonet. This will propablty change when
   zones are coming. Those standards are ready, but I haven't seen them
   yet.

   Mon Oct  3 02:43:49 1988
   zones-format will be <name>@<point>.<node>.<net>.<zone>.fidonet.
   Fidonet-like format maybe would be easier to get used to but
   parsing it with sendmails etc would be more difficult. Notice that there
   certainly will be problems if different number of numbers than 4
   is specified. I will use following solution:

   case 4: assume point.node.net.zone
   case 3: assume node.net.zone (point 0)
   case 2: assume node.net (in current zone, point 0)
   case 1: assume node (in current net, zone, point 0)

   Other way would be to force users to use zones and/or try to check
   other possibilities by checking if its on the nodelist. I don't
   really like points, they make life difficult, they could just be local
   nodes off the nodelist, and no special support would be needed!

   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* LINTLIBRARY */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "nodelist.h"
#include "shuffle.h"


/* Parse fidonet address to name, net and node. Address contains address,
   and name, net and node will be returned. Return NULL is it was valid
   fidonet address, otherwise string to error message. */

char *
parse_address(address, name, node)
     char *address, *name;
     Node *node;
{
  static char error[64];
  register char *cp;
  register int cnt;

  /* make address to lowercase */
  for (cp = address; *cp; cp++)
    if (isupper(*cp))
      *cp = tolower(*cp);

  /* Get name. We assume that name has space at least 36 charcers (maximum
     length of name in fido). First check wheather format is name@domain
     of domain!name format. */
  if ((cp = strchr(address, '!')) != NULL)
    {
      debug(2, "Fidonet address domain!name");
      for (cp++, cnt = 0; *cp && cnt < 35; cnt++, cp++)
        name[cnt] = *cp;
      name[cnt] = 0;
      cp = address;
      debug(3, "Name %s", name);
    }
  else
    {
      debug(2, "Fidonet address name@domain");
      for (cp = address, cnt = 0; *cp && cnt < 35 && *cp != '@'; cp++, cnt++)
        name[cnt] = *cp;
      name[cnt] = 0;
      debug(3, "Name %s", name);

      if (*cp != '@')
        {
          /* name is too long or address is invalid */
          while (*cp && *cp != '@')
            cp++;
          if (*cp == 0)
            {
              debug(1, "Invalid address: %s: missing @", address);
              (void) sprintf(error, "No @ in address %s", address);
              return error;
            }
        }
      cp++;
    }

  debug(2, "Address %s, up to '!' or end", cp);

  if (parseinternode(cp, node))
    {
      sprintf(error, "Bad address %s", cp);
      return error;
    }

#ifdef NEEDED
  /* now parse address, cp points to beginning of it. */
  for (*node = 0; isdigit(*cp); cp++)
    *node = 10 * *node + *cp - '0';
  if (*cp != '.')
    {
      debug(1, "Invalid address: %s: no . after node", address);
      debug(2, "Rest of address %s, node %d", cp, *node);
      (void) sprintf(error, "No net number in address %s", address);
      return error;
    }

  /* get net */
  for (cp++, *net = 0; isdigit(*cp); cp++)
    *net = 10 * *net + *cp - '0';
  if (*cp != '.')
    {
      debug(1, "Invalid address: %s: no . after net", address);
      debug(2, "Rest of address %s, net/node %d/%d", *net, *node);
      (void) sprintf(error, "No domain in address %s", address);
      return error;
    }

  cp++;
  debug(3, "Domain %s", cp);

  /* check that .fidonet is present */
  if (strncmp(cp, "fidonet", 7) || (cp[7] != 0 && cp[7] != '!'))
    {
      debug(1, "Invalid address: %s: not .fidonet domain", address);
      (void) sprintf(error, "Domain is not .fidonet in address %s", address);
      return error;
    }

#endif
  /* we're done */
  return NULL;
}

returnbad(errtype, s, node)
     char *errtype, *s;
     Node *node;
{
  log("Bad address %s : %s, returning my node", s, errtype);
  node->zone = MY_ZONE;
  node->net = MY_NET;
  node->node = MY_NODE;
  node->point = MY_POINT;
  return -1;
}

/* Parse internet format fidonet address */

parseinternode(address, node)
     char *address;
     Node *node;
{
  char *p, *s;
  int numbers[4], count = 0;

  s = alloca(strlen(address) + 1);
  strcpy(s, address);
  numbers[0] = numbers[1] = numbers[2] = numbers[3] = -1;

  if (strlen(s) > strlen(".fidonet"))
    if (!strcmp(s + strlen(s) - strlen(".fidonet"), ".fidonet"))
      s[strlen(s) - strlen(".fidonet")] = 0;

  for (p = strtok(s, "."); p; p = strtok(NULL, "."))
    numbers[count++] = atoi(p);

  if (!count) return returnbad("empty fidonet address", address, node);
  if (count == 4)
    {
      node->zone = numbers[3];
      node->net = numbers[2];
      node->node = numbers[1];
      node->point = numbers[0];
      return 0;
    }

  if (numbers[0] == -1) return returnbad("no node", address, node);
  if (numbers[1] == -1) numbers[1] = MY_NET;
  if (numbers[2] == -1) numbers[2] = MY_ZONE;
  node->zone = numbers[2];
  node->net = numbers[1];
  node->node = numbers[0];
  node->point = 0;
  return 0;
}

/* It would have been more sensible if
   fidonet addresses were down to up, it would be easier to parse.

   Fri Oct  7 12:09:21 1988
   Removes non-numeric chars at start, Opus puts 'Opus ' there
   */

parsefnetaddress(s, node)
     char *s;
     Node *node;
{
  char *p, *lastnumber;
  char nodenbuf[100];

  strncpy(nodenbuf, s, 99);
  nodenbuf[99] = 0;
  s = nodenbuf;

  node->zone = 0;
  node->net = 0;
  node->node = 0;
  node->point = 0;
  p = s;

  while (!isdigit(*p) && *p) p++;

  while (*p) {
    switch (*p) {
     case '0':
     case '1':
     case '2':
     case '3':
     case '4':
     case '5':
     case '6':
     case '7':
     case '8':
     case '9':
      {
    lastnumber = p;
    while (isdigit(*++p));
    continue;
      }
     case ':':
      /* Previous number is zone */
      if (node->zone) return returnbad("two zones", s, node);
      node->zone = atoi(lastnumber);
      lastnumber = p + 1;
      break;
     case '/':
      /* Previous number is net */
      if (node->net) return returnbad("two nets", s, node);
      node->net = atoi(lastnumber);
      lastnumber = p + 1;
      break;
     case '.':
      /* Previous number is node */
      if (node->node) return returnbad("two nodes", s, node);
      node->node = atoi(lastnumber);
      lastnumber = p + 1;
      break;
     case 0:
      /* End: lastnumber should have point (or its at end, which gives us 0) */
      node->node = atoi(lastnumber);
      if (node->zone == 0) node->zone = MY_ZONE;
      if (node->net == 0) node->net = MY_NET;
      return 0;
     default:
      log("Bad char %d in %s", *p, s);
      return returnbad("bad char", s, node);
    }
    p++;
  }
  if (node->zone == 0) node->zone = MY_ZONE;
  if (node->net == 0) return returnbad("no net", s, node);
  if (node->node == 0)
    node->node = atoi(lastnumber);

  return 0;
}

/* Return address in string format */

char *ascnode(node)
     Node node;
{
  SHUFFLEBUFFERS;

  sprintf(tcharp, "%d:%d/%d.%d", node.zone, node.net, node.node, node.point);
  return tcharp;
}

/* Internet format */
char *internode(node)
     Node node;
{
  SHUFFLEBUFFERS;

  if (node.point)
    sprintf(tcharp, "%d.%d.%d.%d.fidonet", node.point, node.node, node.net,
        node.zone);
  else
    sprintf(tcharp, "%d.%d.%d.fidonet", node.node, node.net, node.zone);

  return tcharp;
}

/* same for index node structure */

char *ascnodei(node)
     NODEINDEX node;
{
  SHUFFLEBUFFERS;

  sprintf(tcharp, "%d:%d/%d", node.zone, node.net, node.node);
  return tcharp;
}
