#ifndef lint
static char *sccsid = "@(#)%M%  %I%  Teemu Torma %H%";
#endif

/* Unpaketize fido-mail packets and send mail to reciver or send it to
   news-server.

   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <varargs.h>
#include <time.h>
#include <dirent.h>
#include "hsu.h"
#include "config.h"
#include "fnet.h"
#include "fpack.h"
#include "nodelist.h"
#include "sysexits.h"
#include "fnews.h"

#define MAXARGS (32) /* maximum number of arguments */

extern time_t time();
extern char *tzname[];
extern int getopt();
extern int optind;
extern char *optarg;
extern void exit(), perror(), free();
extern char *malloc();
extern time_t dateconv();
extern void swab();

int verbose = INIT_VERBOSE;
int newsmode = FALSE;
int acceptprivate = FALSE;
int trashprivate = FALSE;

#ifdef SCCS
char *version = "%I%";
#else
char *version = PROGRAMNAME;
#endif

/* Test if string is totally numeric. */

bool
numeric(s)
     register char *s;
{
  while (*s)
    if (!isdigit(*s++))
      return False;
  return True;
}

/* Return msdos interger as machine integer */

int
int16(msint)
     INT16 msint;
{
  static INT16 value;

#ifdef SWAB_BYTES
  swab((char *) &msint, (char *) &value, 2);
#else
  value = msint;
#endif
  return (int) value;
}

static FILE *badtemp = NULL;

/*VARARGS2*/
tprintf(fp, fmt, va_alist)
     FILE *fp;
     char *fmt;
{
  char buffer[BUFSIZ];
  va_list pvar;

  va_start(pvar);
  vsprintf(buffer, fmt, pvar);
  fputs(buffer, fp);
  if (badtemp) fputs(buffer, badtemp);
  va_end(pvar);
}

tputs(buffer, fp)
     char *buffer;
     FILE *fp;
{
  fputs(buffer, fp);
  if (badtemp) fputs(buffer, badtemp);
}

#define tputc(c, fp) putc(c, fp); if (badtemp) putc(c, badtemp);

/* Replacement for fgets(3S) to understand cr's generated by Fido
   and 'soft' cr's generated by SEAdog. It return EOF if text is over,
   ie. 0 is got from file.

   Sat Oct  1 10:15:46 1988
   Must notice cr without linefeed, as confmail seems to send
   strange ids without lf.

   Mon Oct  3 01:51:01 1988
   Notice * Origin header and extract node from it. Useless time consumer
   when looking for mail.
   */

static char *
ffgets(buffer, maxlen, fp)
     char *buffer;
     int maxlen;
     FILE *fp;
{
  register int c, ch, index;
  register char *cp;
  char buf[BUFSIZ];
  static char wordsave[BUFSIZ];
  /* TRUE if last line was origin line without valid node */
  static int last_line_was_origin = FALSE;
  /* TRUE if last character caused line wrap */
  static int last_char_wrapped = FALSE;
  Node node;

  /* There might be wrapped word lying around */
  if (*wordsave)
    {
      strcpy(buffer, wordsave);
      strsclean(buffer);
      debug(20, "Picked up word '%s'", buffer);
      *wordsave = 0;
    }
  else
    *buffer = 0;

  cp = buffer + strlen(buffer);

  while (--maxlen > 0 && (c = getc(fp)) != EOF && c)
    {
      /* Hard carriage return */

      if (c == '\r')
    c = '\n';
      else if (c == '\n' || c == 0x8d || c == '\215')
    {
      /* Forget about these ! */
      continue;
    }
      else
    if (c == '\001')
      {
        /* Kludge. Stupid idea to put control chars to messages,
           but thats the way it is, replace with something which
           doesn't make programs expecting ascii mad */
        strncpy(cp, "FSC-Control:", 12);
        cp += 12;
        c = ' ';
      }

      /* If last character caused line wrap, and we now got another
     linefeed, skip this linefeed to avoid unneeded empty lines. */

      if (last_char_wrapped)
    {
      if (c == '\n')
        {
          last_char_wrapped = FALSE;
          continue;
        }

      if (isspace(c) && strempty(buffer)) continue;
    }

      *cp++ = c;

      if (c == '\n')
        break;

      *cp = 0;

      /* Try to wrap if line is too long and it is not a seen-by, origin
     or path line. */
      if (strlen(buffer) >= MAX_LINELEN - 1 &&
      strncmp(" * Origin:", buffer, 10) &&
      strncmp("SEEN-BY:", buffer, 8) &&
      strncmp("FSC-Control:", buffer, 12)) /* - 1 for \n */
    {
      last_char_wrapped = TRUE;

      /* Search for place to cut */
      for (index = strlen(buffer) - 1; index >= 0; index--)
        {
          c = buffer[index];
          if (index <= MAX_LINELEN / 3)
        {
          /* Too long, cut. */
          *cp++ = c = '\n';
          goto collected;
        }

          /* Note: [\]{|}@` are not considered punctuation because
         they are used in some countries for national characters. */
          if (isspace(c) || (ispunct(c) && !strchr("[\\]{|}@`", c)))
        {
          /* Wrap here! */
          cp = buffer + index + 1; /* Punctuation left on this line */
          strcpy(wordsave, cp);
          debug(20, "saving word '%s'", wordsave);
          *cp++ = c = '\n';
          goto collected;
        }
        }
    }

      last_char_wrapped = FALSE;
    }

 collected:

  /* if we got nul, put it back if occurred in the middle of line */
  if (!c && cp != buffer)
    (void) ungetc(0, fp);

  *cp = 0; /* Cut it here */

  /* This is really nasty part: Try to work out reply-to path from
     origin for those people who don't have node in nodelist.
     This should handle both situations where origin line is split by
     some stupid mailer, or because origin line was too long (sysops,
     please don't use long system identifiers, it causes lots of trouble!).
     It checks that line doesn't start with SEEN-BY: or FSC-Control as
     those things generally follow origin lines. */

  if (!strncmp(" * Origin:", buffer, 10) || last_line_was_origin) {
    char *left, *right;

    if (last_line_was_origin)
      {
    last_line_was_origin = FALSE;
    /* If its seen-by or control, it probably isn't continuation! */
    if (!strncmp("SEEN-BY:", buffer, 8) ||
        !strncmp("FSC-Control:", buffer, 12))
      goto out;
      }
    else
      last_line_was_origin = TRUE;

    strcpy(buf, buffer);
    right = buf;

    for (;;)
      {
    if ((left = strchr(right, '(')) && (right = strchr(left + 1, ')')))
      {
        *right = 0;
        if (parsefnetaddress(++left, &node))
          {
        debug(1, "Could not parse %s", left);
          }
        else
          {
        memcpy( (char *) &originnode, (char *) &node, sizeof(Node));
        debug(1, "Parsed %s to %d:%d/%d.%d", left, originnode.zone,
              originnode.net, originnode.node, originnode.point);
          }
        left = ++right;
      }
    else
      break;
      }
  }

 out:
  return ((!c || c == EOF) && cp == buffer) ? (char *) 0 : buffer;
}

/* Execute sender of fido-message. Argument will be program name, anrgument
   for that and pid to return. If command is not empty, use it instead
   of given program and build parameter table. */

static char command[64];

FILE *
open_sender(program, args, pid)
     char *program, **args;
     int *pid;
{
  FILE *fp;
  int fd[2], count = 0;
  char *p, *realargs[MAXARGS];
  char *cmd, *realprogram;

  cmd = alloca(strlen(command) + 1);
  strcpy(cmd, command);

  if (*cmd)
    {
      while (p = strtok(cmd, SEPARATORS))
    {
      realargs[count++] = p;
      cmd = NULL; /* For strtok */
    }

      realargs[count++] = NULL;
      realprogram = *realargs;

      if (realprogram)
    {
      program = realprogram;
      args = realargs;
    }
    }

  if (pipe(fd) == -1)
    {
      perror("funpack: pipe");
      return (FILE *) 0;
    }

  switch (*pid = fork())
    {
    case -1:
      perror("funpack: fork failed");
      return (FILE *) 0;
    case 0:
      (void) close(0);
      if (dup(fd[0]) == 0)
        {
          (void) close(fd[0]);
          (void) close(fd[1]);
          if (args)
            (void) execvp(program, args);
          else
            (void) execlp(program, basename(program), (char *) 0);
          perror(program);
        }
      else
        perror("funpack: dup");
      exit(EX_OSERR);
    default:
      (void) close(fd[0]);
      if ((fp = fdopen(fd[1], "w")) == NULL)
        {
          perror("funpack: fdopen");
          return (FILE *) 0;
        }
    }
  return fp;
}

static Packet header;

read_header(fp)
     FILE *fp;
{
  FGETINT16(header.orig_node, fp);
  FGETINT16(header.dest_node, fp);
  FGETINT16(header.year, fp);
  FGETINT16(header.month, fp);
  FGETINT16(header.day, fp);
  FGETINT16(header.hour, fp);
  FGETINT16(header.minute, fp);
  FGETINT16(header.second, fp);
  FGETINT16(header.rate, fp);
  FGETINT16(header.ver, fp);
  FGETINT16(header.orig_net, fp);
  FGETINT16(header.dest_net, fp);
  header.product = getc(fp);
  header.x1 = getc(fp);
  FREAD(header.pwd_kludge, 8, 1, fp);
  FGETINT16(header.orig_zone, fp);
  if (header.orig_zone == 0) header.orig_zone = int16(MY_ZONE);
  FGETINT16(header.dest_zone, fp);
  if (header.dest_zone == 0) header.dest_zone = int16(MY_ZONE);
  FREAD(header.B_fill2, 16, 1, fp);
  FREAD( (char *) &header.B_fill3, 4, 1, fp);
  return ferr(fp);
}

/* Return int from file. Int in file is supposed to be 16 bit ms-dos
   integer. */

int
read_int(fp)
     FILE *fp;
{
  static INT16 value;

  if (fread((char *) &value, 2, 1, fp) != 1)
    {
      if (ferr(fp))
    log("Cannot read file, errno %d : %s", errno, sys_errlist[errno]);

      value = 0;
    }

  debug(8, "< %02x(%ld)", int16(value), ftell(fp));
  return int16(value);
}

/* Read null-terminated string from file. Ensure that buffer is also
   null-terminated. Remove possible \n:s from end, they are generated by
   some buggy mailers. */

void
get_string(buffer, fp, nbytes)
     char *buffer;
     FILE *fp;
     int nbytes;
{
  register int n;
  char *p;

  debug(8, "get string start %ld", ftell(fp));

  for (n = 0, *buffer = 0; n < nbytes; n++)
    if ((buffer[n] = getc(fp)) == 0)
      break;
    else
      debug(8, "<%d %c>", buffer[n], buffer[n]);

  /* If still more chars in buffer, skip them until null char found */
  if (n >= nbytes)
    {
      debug(8, "Skipping rest");
      while(getc(fp));
    }

  buffer[nbytes] = 0;

  /* Remove \n from end if its there, its a bug */
  if (p = strchr(buffer, '\n')) *p = 0;

  debug(8, "Getstring at %ld %s", ftell(fp), buffer);
}

#define NGFLAG_ACCEPT_PRIVATE 0
#define NGFLAG_COMMAND 1
#define NGFLAG_TRASH_PRIVATE 2

static char distribution[64];
static char *ngflags[] = { "accept-private", "command", "trash-private", "" };

/* Like strtok but returns empty string instead of null if no more thigns
   found */

char *estrtok(s, sep)
     char *s, *sep;
{
  char *p;

  if (p = strtok(s, sep)) return p;
  return "";
}

char *
get_ng(config, echo, distrib)
     FILE *config;
     char *echo, *distrib;
{
  static char conv[BUFLEN];
  char *gr, *flag;

  debug(2, "Checking echolist '%s'", echo);

  *command = 0;
  section(SECT_AREA_NG, config);
  trashprivate = FALSE;
  acceptprivate = FALSE;
  while (getcl(conv, BUFLEN, config))
    {
      debug(3, "Config line '%s'", conv);

      gr = estrtok(conv, SEPARATORS);
      if (!strcmp(gr, echo))
    {
      /* Matched, take distribution and return newsgroup */

      gr = estrtok(NULL, SEPARATORS);
      strcpy(distrib, estrtok(NULL, SEPARATORS));
      while (flag = strtok(NULL, SEPARATORS))
        switch(listscan(ngflags, flag))
          {
           case NGFLAG_ACCEPT_PRIVATE:
        acceptprivate = TRUE;
        break;

           case NGFLAG_COMMAND:
        /* Fails if fnews.cf has DEL char in it, but thats
           mostly a philosophical question. */
        strcpy(command, estrtok(NULL, "\377"));
        break;

           case NGFLAG_TRASH_PRIVATE:
        trashprivate = TRUE;
        break;

           case -1:
           default:
        log("Bad flag '%s' for newsgroup %s", flag, gr);
        break;
          }

      debug(3, "Match, return newsgroup '%s', distribution %s",
        gr, distrib);
      return gr;
    }
    }
  log("No newsgroup for '%s' found, return junk, distribution local", echo);
  strcpy(distrib, "local");
  return "junk";
}

/* Check if message is news-message (currenlty: if first line begins
   with AREA:). If area is found, we'll return name for that area,
   otherwise NULL. */

char *
news_msg(fp)
     FILE *fp;
{
  FILE *config;
  long offset = ftell(fp);
  char *cp;
  static char area[64];

  if (ffgets(area, 64, fp) && !strncmp(area, "AREA:", 5))
    {
      /* this is echomail-message */
      area[strlen(area) - 1] = 0;

      /* strip possible spaces */
      for (cp = area + 5; *cp && isspace(*cp); cp++);

      if ((config = pfopen(LIBDIR, "fnews.cf", "r")) == NULL)
    {
      log("$Unable to open config file");
      exit(1);
    }

      strcpy(cp, get_ng(config, cp, distribution));
      fclose(config);

      /* return converted area-name */
      return cp;
    }
  else
    {
      /* this is not echomail message, seek back */
      (void) fseek(fp, offset, 0);
      return (char *) 0;
    }
  /* NOTREACHED */
}

/* Return date of message. Date will be read and converted to one
   long-interger as normal Unix-time will be.

   Both SEAdog and Fido date formats are understood.
   SEAgod: Mon 1 Jan 86 02:34
   Fido:   01 Jan 86 02:34:56 */

time_t
lgetdate(packet)
     FILE *packet;
{
  char buffer[20];
  int c;
  time_t timevar;
  int n;

  /* read date from packet */
  for (n = 0; n < 20; n++)
    if ((buffer[n] = getc(packet)) == NULL) break;

  /* Some message-packers do mistakes! Date should be 20 bytes but
     they start name directly after null terminating 18-char date
     used in some systems. Check if following char is null or not,
     and if not, put it back there as it probably is first char in
     recipent name. This seems to be problem in OMMM, but I'm not
     sure yet.

     Wed Nov 16 21:11:34 1988 Seems that the bug is in fsc001, as
     I constantly keep receiving messages which 19 byte date?
     */

#ifdef FSC_IS_REALLY_CORRECT
  for (n++; n < 20; n++)
    if (c = getc(packet))
      {
    ungetc(c, packet);
      }
#endif

  buffer[19] = 0;
  debug(8, "Getdate %s at %ld", buffer, ftell(packet));

  /* try to get date */
  timevar = getdate(buffer, (struct timeb *) NULL);
  return timevar;
}

/* Remove 'of net/node' from name. Number will be saved
   for later use and used as reply-to address, as I think most users use
   it as their home system or if they are sysops, as their node. */

search_node(from, node)
     char *from;
     Node *node;
{
  char *s, *p, *of;
  Node tempnode;

  s = alloca(strlen(from) + 1);
  strcpy(s, from);

  p = strtok(s, WHITESPACE);
  while (p)
    {
      if (!stricmp(p, "of"))
    {
      of = p;
      /* Skip possible multiple 'of's */
      for (; (p = strtok(NULL, WHITESPACE)) && !stricmp(p, "of"););
      /* Of and something else follows, try to parse */
      if (p)
        {
          if (!parsefnetaddress(p, &tempnode))
        {
          if (node) *node = tempnode;
          /* Of net/node should be the last string */
          if ((p = strtok(NULL, WHITESPACE)) == NULL)
            {
              /* Remove 'of ...' from name */
              *(from + (int) (of - s)) = 0;
              strclean(from);
              return; /* Found it */
            }
          else
            continue; /* Something follows, try again */
        }
        }
      else
        return; /* no more stuff */
    }
      p = strtok(NULL, WHITESPACE);
    }
  return;
}

/* Remove userids from names, like "James Smith (SMITH)" will become
   "James Smith". Simple algorithm now, but its enough. Scandinvian
   chars are translated to a and o, and other special chars are
   removed. */

remove_id(name)
     char *name;
{
  char *p, *cp;

  if (p = strchr(name, '(')) {
    while (*p != ')' && *p)
      for (cp = p; *cp = *(cp + 1); cp++); /* Remove one char */

    if (*p == ')')
      for (cp = p; *cp = *(cp + 1); cp++); /* Remove last ) */
  }

  /* Remove blanks from the end */
  while (strlen(name) && isspace(name[strlen(name) - 1]))
    name[strlen(name) - 1] = 0;
  (void) ascii_convert(name);
  fine_convert(name);
  stripbad(name);
}

/* Search alias name which matches with fidonet name, return NULL
   if no alias specified. */

char *get_alias(name)
     char *name;
{
  char buffer[BUFSIZ];
  char *cp;
  FILE *fp;
  static char unixname[BUFSIZ], fidoname[BUFSIZ];

  if (fp = fopen(ALIAS, "r"))
    {
      while (fgets(buffer, BUFSIZ, fp))
    {
      buffer[strlen(buffer) - 1] = 0;
      if (*buffer != '#')
        {
          if ((cp = strchr(buffer, ' ')) ?
          cp : (cp = strchr(buffer, '\t')))
        {
          *cp = 0; /* Break unixname out */
          strcpy(unixname, buffer); /* And save it */
          debug(8, "Unix name %s", unixname);
        }
          else
        {
          /* No space or tab found, probably bad line */
          debug(1, "Bad alias line %s", buffer);
          continue;
        }

          /* Search for name start, there may be space between */
          cp++;
          while (*cp && isspace(*cp)) cp++;
          if (!*cp)
        {
          debug(1, "Bad alias line %s", buffer);
          continue;
        }

          strcpy(fidoname, cp); /* Save fidonet name */
          debug(8, "Fidoname %s", fidoname);

          if (!stricmp(fidoname, name))
        {
          fclose(fp);

          /* There may be node specs after name, null them out */
          if (cp = strchr(unixname, ',')) *cp = 0;

          debug(8, "Fidoname %s matched with %s, return %s",
            fidoname, name, unixname);
          return unixname;
        }
        }
    }
    }

  fclose(fp);
  return NULL;
}

/* Save bad article from file given to bad directory */

savebad(fp)
     FILE *fp;
{
  char *fname, buffer[BUFSIZ];
  FILE *badfile;

  log("Saving bad article/mail to %s",
      fname = sprintfs("%s/bad%ld", BADARTICLES, sequencer(BADSEQ)));
  if (badfile = fopen(fname, "w+"))
    {
      rewind(fp);
      while (fgets(buffer, BUFSIZ, fp))
    fputs(buffer, badfile);
    }
  else
    {
      log("$Could not open bad article file");
      return -1;
    }
  fclose(badfile);
  return 0;
}

/* Unpack packet and all files in it. Packet's header will be stripped
   off. For each message check if it is news-msg (First line begins
   with AREA:). If it is, send it to news-sender sfnews, otherwise
   send it to rmail. Address is given in to-field, or if it wont
   fit to it, in the first line of message. In later case to-field
   must be "Usenet". */

void
unpack(packet, packetnode)
     FILE *packet;
     Node packetnode;
{
  int count, attributes, messagetype;
  char to[36], from[36], realto[40], realfrom[40], subject[72];
  char badname[BUFSIZ];
  char *args[MAXARGS];
  char buffer[BUFSIZ], *cp, *p;
  FILE *sender, *newssender;
  int n, pid, stat_loc, c;
  Node *entry, mynode, orignode, destnode, fromnode;
  char hostname[10];
  time_t msg_date;
  char *area;

  /* get node-entry fo packet-sender */
  if (node_entry(packetnode) == NULL)
    {
      log("Unknown packet sender: %s", ascnode(packetnode));
      return;
    }

  mynode.zone = MY_ZONE;
  mynode.net = MY_NET;
  mynode.node = MY_NODE;
  mynode.point = MY_POINT;

  if ((entry = node_entry(mynode)) == NULL)
    {
      log("Unable to find this net/node from nodelist");
      return;
    }

  /* get our uucp-nodename */
  if (gethostname(hostname, 10) == -1)
    {
      log("$Unable to get hostname");
      return;
    }

  while ((messagetype = read_int(packet)) == MSGTYPE)
    {
      *args = NULL;
      originnode.zone = -1;
      fromnode.zone = -1;
      orignode.zone = packetnode.zone; /* Orignode zone and point are not */
      orignode.point = packetnode.point; /* included in messages. */
      destnode.zone = packetnode.zone;
      destnode.point = packetnode.point;

      /* get nodes information about message */
      orignode.node = read_int(packet);
      destnode.node = read_int(packet);

      /* get nodes from message */
      orignode.net = read_int(packet);
      destnode.net = read_int(packet);

      debug(2, "Original net/node = %s", ascnode(orignode));
      debug(2, "Destination net/node = %s", ascnode(destnode));

      /* we're not interested about attributes currenty */
      attributes = read_int(packet);

      /* through away cost */
      (void) read_int(packet);

      /* get date */
      msg_date = lgetdate(packet);

      /* get receiver of message */
      get_string(to, packet, 35);
      search_node(to, (Node *) NULL);
      remove_id(to);
      debug(2, "Msg is to '%s'", to);

      /* get sender of message */
      get_string(from, packet, 35);
      search_node(from, &fromnode);
      remove_id(from);
      debug(2, "Msg is from '%s'", from);

      /* get subject */
      get_string(subject, packet, 71);

      /* Remove trailing blanks */
      for (count = strlen(subject) - 1; count >= 0 && isspace(subject[count]);
       count--) subject[count] = 0;

      /* News expects some kind of subject and ignores the message
     without one? */
      if (!*subject) strcpy(subject, "No subject");

      debug(2, "Subject is '%s'", subject);

      /* check that message is to this node */
      if (!samenode(destnode, mynode))
        {
          log("Msg from %s to %s at %s: wrong node address",
          from, to, ascnode(destnode));
          goto error;
        }

      /* check if this is news-message. Private messages will not
         be forwarded to readnews, they go to mail, if received is
     known, otherwise they will be thrown away. Exception are
     conferences which are marked accept-private. */
      newsmode = FALSE;
      if ((area = news_msg(packet)) &&
      (acceptprivate || !(attributes & ATTR_PRIVATE)))
    {
      /* This is news-artcile. Open sendfidonews and give area name as
         argument to it. Input of sfnews will be just like input
         of mail. */

      debug(1, "Message is news-article");
      newsmode = TRUE;

      /* create args for sender */
      *args = strsave(RNEWS);
#ifdef NEEDED
      args[1] = strsave(area);
      args[2] = NULL;
#else
      args[1] = NULL;
#endif
      /* open sender */
      if (!(sender = tmpfile()))
        {
          log("Can not create temp file, errno %d: %s",
          errno, sys_errlist[errno]);
          goto error;
        }

      if ((newssender = open_sender(*args, args, &pid)) == NULL)
        {
          log("Can not execute %s", *args);
          goto error;
        }

      badtemp = NULL; /* tmp file for news messages will be
                 created later. */
        }
      else
        {
          debug(1, "Message is for mail");
      if (area)
        {
          debug(1, "Private message for area %s", area);
          if (trashprivate) goto error;
        }

          /* If message receiver is Usenet, then receiver of mail will
             be at first-line of message separated by commands/spaces.
             If receiver is not usenet, mail will be sent to normal
             receiver, but in this case all charactes will be converted
             to lower case (Fido changes them, you know). */

          if (!strcmp(to, "Usenet"))
            {
              if (ffgets(buffer, BUFSIZ, packet) == NULL)
                {
                  log("Missing receiver in msg from %s at %s", from,
                      ascnode(orignode));
                  goto error;
                }
              buffer[strlen(buffer) - 1] = 0;
            }
          else
            {
          debug(8, "Searching alias for %s", to);
          if (p = get_alias(to))
        {
          (void) strcpy(buffer, p);
          debug(8, "Got alias %s", buffer);
        }
          else
        {
          if (area)
            {
              log("Skipping private echo for %s", to);
              goto error; /* If private echo message, skip */
            }
          (void) strcpy(buffer, to);
          debug(8, "No alias, using %s", buffer);
        }

              for (n = 0; buffer[n]; n++)
                buffer[n] = tolower(buffer[n]);
            }

          *args = strsave(basename(RMAIL));
          for (n = 1, cp = strtok(buffer, ", \t"); cp && n < MAXARGS;
               cp = strtok((char *) 0, ", \t"), n++)
            args[n] = strsave(cp);
          args[n] = NULL;

          for (n = 1; args[n]; n++)
            log("Sending mail from %s at %s to %s", from, ascnode(orignode),
        args[n]);

          /* open rmail for sending message */
          if ((sender = open_sender(RMAIL, args, &pid)) == NULL)
            {
              log("Can not execute %s", RMAIL);
              goto error;
            }

      if (badtemp)
        fclose(badtemp);

      if ((badtemp =
           fopen(strcpy(badname, mktemp("/tmp/funpXXXXXX")), "w+"))
          == NULL)
        {
          log("$Cannot open tmp file %s", badname);
          goto error;
        }

      area = NULL;

        }

      /* Save real names for further use. Blanks included, */
      if (strchr(from, ' '))
    {
      strcpy(realfrom, " (");
      strcat(realfrom, from);
      strcat(realfrom, ")");
    }
      else
    *realfrom = 0;

      if (strchr(to, ' '))
    {
      strcpy(realto, " (");
      strcat(realto, to);
      strcat(realto, ")");
    }
      else
    *realto = 0;

      /* change all spaces in name to _'s */
      for (n = 0; from[n]; n++)
        if (from[n] == ' ') from[n] = '_';
      /* Same for to field */
      for (n = 0; to[n]; n++)
    if (to[n] == ' ') to[n] = '_';

      /* set From_ line */
      (void) tprintf(sender, "From %d!%s %s remote from %d\n", orignode.node,
                     from, date("%a %h %d %T 19%y", (long *) 0), orignode.net);

      /* Now generate valid RFC 822 header for mail. Some fields may
         be different, in all places there may be comments between (
         and )-charactes. */

      /* This is imporant for news articles, as without this inews
     tries to post it back. This is a bit complicated, as we cannot
     put fidonet path here? Hmm... why not, I have to check this out! */
      (void) tprintf(sender, "Path: %s!%s\n", RECEIVE_PATH, from);

      /* print Received: field */
      (void) tprintf(sender, "Received: by %s (funpack%s/%s)\n",
             internode(*entry), version, entry->name);
      (void) tprintf(sender, "\tid AA%05d; %s\n",
                     getpid(), date("%a, %d %h %y %T %o (%z)", (long *) 0));

      /* print Date: field */
      (void) tprintf(sender, "Date: %s\n", date("%a, %d %h %y %T %o",
                                                &msg_date));

      /* print From: field */
      (void) tprintf(sender, "From: %s@%s%s\n", from, internode(orignode),
                     realfrom);

      /* print Subject: field */
      (void) tprintf(sender, "Subject: %s\n", subject);

      /* print Message-Id: field */
      (void) tprintf(sender, "Message-Id: <%s.AA%ld@%s>\n",
                     date("%y%m%q%H%M", (long *) 0), sequencer(IDSEQUENCE),
             internode(*entry));

      if (area)
    {
      (void) tprintf(sender, "Newsgroups: %s\n", area);
      if (strlen(distribution))
        (void) tprintf(sender, "Distribution: %s\n", distribution);

      /* print Reply-To: field */
      /* Note: This is not accurate yet, as * Origin can change
         address to other node */
      (void) tprintf(sender, "Reply-To: %s@%s%s\n",
             from, internode(destnode), realfrom);
    }
      else
    {
      /* print To: field */
      (void) tprintf(sender, "To: ");
      for (n = 1; args[n]; n++)
        {
          (void) tprintf(sender, "%s", args[n]);
          if (args[n + 1])
        (void) tprintf(sender, ", ");
        }
      tprintf(sender, "\n");

      /* print Reply-To: field */
      (void) tprintf(sender, "Reply-To: %s@%s%s\n",
             from, internode(orignode), realfrom);
    }

      /* done with header, now send message text */

      tprintf(sender, "\n");
      while (ffgets(buffer, BUFSIZ, packet))
        (void) tputs(buffer, sender);

      /* News messages are a little bit more compilicated. News
     article has been saved in temp file, and now we need to
     read it through, replace Reply-To with correct return address
     taken from origin row, nodelist, or if not found, echo feed.
     Then really send mail to newssender. */

      if (area)
    {
      debug(1, "Reading back news article");
      rewind(sender);

      if (badtemp)
        fclose(badtemp);

      if ((badtemp =
           fopen(strcpy(badname, mktemp("/tmp/funpXXXXXX")), "w+"))
          == NULL)
        {
          log("$Cannot open tmp file %s", badname);
          goto error;
        }

      while (fgets(buffer, BUFSIZ, sender))
        {
          if (!strncmp(buffer, "Reply-To:", 9))
        {
          if (search_name(from))
            {
              debug(1, "%s is not a sysop, try his name", from);
              if (fromnode.zone != -1)
            originnode = fromnode;
              else
            {
              debug(1, "No node in his name, try * Origin", from);
              if (originnode.zone == -1)
                {
                  debug(1, "No * Origin, replace with echo feed");
                  originnode = orignode;
                }
              else
                debug(2, "Origin %s", ascnode(originnode));
            }
            }

          (void) tprintf(newssender, "Reply-To: %s@%s%s\n",
                 from, internode(originnode), realfrom);

          /* Set Comment-To field */
          if (search_name(to))
            {
              debug(1, "%s is not a sysop, try * Origin", to);
              if (originnode.zone == -1)
            {
              debug(1, "No * Origin, replace with echo feed");
              originnode = orignode;
            }
              else
            debug(2, "Origin %s", ascnode(originnode));
            }

          (void) tprintf(newssender, "Comment-To: %s@%s%s\n", to,
                 internode(originnode), realto);
        }
          else
        (void) tputs(buffer, newssender);
        }
      fclose(newssender); /* sender will vanish when its closed! */
    }

      /* done with this msg, wait process to finish */
      (void) fclose(sender);
      while ((n = wait(&stat_loc)) != pid && n != -1);

      debug(2, "Wait status: %o", stat_loc);
      if (stat_loc)
    savebad(badtemp);

      fclose(badtemp);
      unlink(badname);

      debug(1, "Done with message");

      /* free argument-list */
      for (n = 0; args[n]; n++)
        free(args[n]);
      continue;

      /* in the case of error skip text of message */
    error:
      while ((c = getc(packet)) && c != EOF);

      /* free argument-list */
      for (n = 0; args[n]; n++)
        free(args[n]);
    }

  if (messagetype != MSGTYPE && messagetype != EOF && messagetype != 0)
    log("Strange ending: %d", messagetype);

  debug(1, "Done with packet");
}

/* ARGSUSED */
int
main(argc, argv, envp)
     int argc;
     char **argv, **envp;
{
  struct dirent *dir;
  DIR *dp;
  int c;
  FILE *packet;
  char files[BUFLEN];
  Node node;
  bool nocheck = False;
  char *error, *p;
  Node packetnode;

  node.zone = -1;
  while ((c = getopt(argc, argv, "if:vV:")) != EOF)
    switch (c)
      {
      case 'V':
        version = optarg;
        break;
      case 'i':
        nocheck = True;
        break;
      case 'v':
        verbose++;
        break;
      case 'f':
    if (parsefnetaddress(optarg, &node)) exit(1);
        break;
      default:
        fprintf(stderr,
        "Usage: %s [-v] [-f [[<zone>:]<net>/]<node>[.<point>]]\n",
        *argv);
        exit(EX_USAGE);
      }

  /* create name for unpacking */
  if (node.zone == -1)
    (void) strcpy(files, "");
  else
    {
      sprintipacketname(files, node);
      /* Cut sequence number off */
      if (p = strrchr(files, ".")) *p = 0;
    }

  debug(2, "Unpacking packets beginning with %s", files);

  /* try to update nodelist-index */
  if (error = update_index())
    {
      if (*error == '$')
        log("$Cannot update nodelist-index: %s", error + 1);
      else
        log("Cannot update nodelist-index: %s", error);
      exit(EX_OSERR);
    }

  if (chdir(sprintfs("%s/in", SPOOL)) == -1)
    {
      log("$Cannot chdir to %s/in", SPOOL);
      exit(EX_OSERR);
    };

  if (dp = opendir("."))
    {
      while (dir = readdir(dp))
        if (!strncmp(dir->d_name, files, strlen(files)) && *dir->d_name != '.')
          {

            /* this packet is right */
            debug(1, "Unpacking %s", dir->d_name);

            /* open packet */
            if (packet = fopen(dir->d_name, "r"))
              {
                if (read_header(packet))
          {
            if (feof(packet))
              log("Missing packet header");
            else
              log("Error reading header, errno %d : %s",
              errno, sys_errlist[errno]);
          }
                else
          {
            packetnode.zone = int16(header.orig_zone);
            packetnode.net = int16(header.orig_net);
            packetnode.node = int16(header.orig_node);
            packetnode.point = 0; /* no points in fidonet header? */
            debug(1, "Packet from %s", ascnode(packetnode));
            debug(1, "Time %02d:%02d:%02d %d.%d.%d",
              int16(header.hour),
              int16(header.minute), int16(header.second),
              int16(header.day), int16(header.month),
              int16(header.year));
            debug(1, "Max baud rate %d, version %d, product %d, x %d",
              int16(header.rate), int16(header.ver),
              header.product, header.x1);
            debug(1, "Pwd \"%s\"", header.pwd_kludge);
          }

                  if (nocheck || ((int16(header.dest_zone) == MY_ZONE ||
                   int16(header.dest_zone) == 0) &&
                  int16(header.dest_node) == MY_NODE &&
                  int16(header.dest_net) == MY_NET))
                    unpack(packet, packetnode);
                  else
                    log("Packet is to %d:%d/%d",
            int16(header.dest_zone),
                        int16(header.dest_net),
                        int16(header.dest_node));
                (void) fclose(packet);

        /* Move packet to unpacked directory. */
        if (link(dir->d_name,
             sprintfs("%s/%s", UNPACKED_DIR, dir->d_name)))
          log("$Could not link packet %s", dir->d_name);
        else
          if (unlink(dir->d_name))
            log("$Could not unlink packet %s", dir->d_name);
              }
            else
              log("$Unable open packet %s", dir->d_name);
          }
      (void) closedir(dp);
    }
  else
    {
      log("$Unable to open spool directory");
      exit(EX_OSERR);
    }
  exit(EX_OK);
  /* NOTREACHED */
}
