/* @(#)%M%  %I%  Teemu Torma %H%

   Configure file for FidoNet mailing system.

   @(#)Copyright (c) 1987 by Teemu Torma

   Permission is given to distribute this program and alter this code as
   needed to adapt it to forign systems provided that this header is
   included and that the original author's name is preserved. */

/* Change these defines for your system. */

#ifndef INIT_VERBOSE
#ifdef DEBUG
#define INIT_VERBOSE 20
#else
#define INIT_VERBOSE 0
#endif
#endif

/* Machine information */
#define USG

#ifdef USG
struct timeb
{
  time_t    time;
  unsigned short    millitm;
  short        timezone;
  short        dstflag;
};
#else
#include <sys/timeb.h>
#endif
#include <ctype.h>

/* This is our net and node number */
#define MY_ZONE 2
#define MY_REGION 22
#define MY_NET 504
#define MY_NODE 7
#define MY_POINT 0

/* Define your echo feed here. Currently only one echo feed
   is supported but I work on it... */

#define ECHOFEED_NET 504
#define ECHOFEED_NODE 26

/* How many seconds wait before starting up fidonet handshake */

#define PREWAIT 5

/* How many seconds to wait for line to clear */

#define WAITCLEAR 2

/* How many tries to give for xmodem startup in send. This should be low
   value, it just gives possibility to retry xmodem startup if modems
   handshaked too fast (really a acu configuration problems, dial should
   return after it has a working line available!) */

#define MAX_SEND_RETRIES 1

/* Maximum baud rate to use when calling out */

#define MAXBAUD 1200

/* Define minimum baud rate to use when calling out */

#define MINBAUD 300

/* Width of formatted messages. Lines will be wrapped to be less
   than this. If word is longer than 2/3s of MAX_LINELEN, it will be
   cut instead of correct wrapping. */

#define MAX_LINELEN 78

/* Path to be added messages received. This is mostly to prevent
   news messages to be resent back. Not really a nice way of doing
   this but I feel sleepy now. */
#define RECEIVE_PATH "emma"

/* My domain suffix. If you don't have one, it will just be .UUCP */
#define DOMAIN ".UUCP"

/* Spool directory for packets and sended mail */
#define SPOOL "/usr/spool/fnet"

/* Spool directory for saving unpacked packets (should be cleared
   from time to time.
   NOTE! This directory must be on same file system as SPOOL. */
#define UNPACKED_DIR "/usr/spool/fnet/unpacked"

/* Spool directory for saving sent packets (should be cleared
   from time to time.
   NOTE! This directory must be on same file system as SPOOL. */
#define SENTBUNDLE_DIR "/usr/spool/fnet/sentbundles"

/* Library to hold all configure files and special programs */
#define LIBDIR "/u2/lib/fnet"

/* Program cabable of receiving a news-article (usually rnews) */
#define RNEWS "/usr/bin/rnews"

/* Name of log file */
#define LOGFILE "/u2/lib/fnet/log"

/* Name of orphans file (to put private echo messages to */
#define ORPHANS "/u2/lib/fnet/orphans"

/* Directory for bad messages, rmail or rnews returned nonzero exit */
#define BADARTICLES "/usr/spool/fnet/bad"

/* Name of Message-id sequence file */
#define IDSEQUENCE "/u2/lib/fnet/idseq"

/* Name of Input packet name sequence file */
#define IPACKETSEQUENCE "/u2/lib/fnet/ipacketseq"

/* Name of Output packet name sequence file (in sent packet directory) */
#define OPACKETSEQUENCE "/u2/lib/fnet/opacketseq"

/* Name of bad message sequence file */
#define BADSEQ "/u2/lib/fnet/badseq"

/* Lowist user's uid. */
#define USERUID 50

/* Name of alias file */
#define ALIAS "/u2/lib/fnet/Alias"

/* Mail sender */
#define RMAIL "/bin/rmail"

/* Define this if you have <sysexits.h> */
/* #define HAVE_SYSEXITS /**/

/* Type to hold 16 bit integer */
#define INT16 short

/* Define this if bytes need to be swapped to msdos */
/* #define SWAB_BYTES /**/

/* Define this if you want rfmail to return underlivered mail. You do
   not need this if you are running sendmail or similiar which returns
   undelivered mail. */
#define RETURN_FAILED_MAIL /**/

/* Shortnames, yak */

#define packet_net zz0001zz
#define packet_node zz0002zz

/* Dial translation table. first string stripped out, second one replaced */

#define DIALTABLE "358-0-", "",  "358-", "9",  "", "990"

  /* End of configure section */

#ifdef HAVE_SYSEXITS
# include <sysexits.h>
#else /* not HAVE_SYSEXITS */
# define EX_OK 0 /* successful termination */
# define EX_USAGE 64 /* command line usage error */
# define EX_DATAERR 65 /* data format error */
# define EX_NOINPUT 66 /* cannot open input */
# define EX_NOHOST 68 /* host name unknown */
# define EX_UNAVAILABLE 69 /* service unavailable */
# define EX_SOFTWARE 70 /* internal software error */
# define EX_OSERR 71 /* system error (e.g., can't fork) */
# define EX_OSFILE 72 /* critical OS file missing */
# define EX_CANTCREAT 73 /* can't create (user) output file */
# define EX_IOERR 74 /* input/output error */
#endif /* not HAVE_SYSEXITS */

