#! /bin/sh
#
#	whichtape - locate file(s) in backup data base
#
#	Usage: whichtape path-name
#
if [ $# -lt 1 ]; then
	echo "Usage: $0 path-name ... path-name"
	exit 1
fi
Uncompress=zcat			# CONFIG
sed=/tmp/lookdb$$		# Sed script file

trap "rm -f $sed.?; exit 1" 2 3

#
#	Sed script to crack the control files
#
cat >$sed.A <<"!"
1s/.*/stem=&/
2s/.*/filesys=&/
3s/.*/tapename="&"/
4s/.*/dumplevel="&"/
5s/.*/tdate="&"/
!

#
#	Step through control files
#
for bf in *.C; do
	stem=""
	eval `sed -f $sed.A $bf`	# Get data from control file
	if [ "$stem" = "" ]; then
		echo Format error in control file $bf !!
		continue
	fi
	cat > $sed.B <<!		# Sed script to post-process grep output
s@^@($tapename)	@
s@\$@	$tdate@
!
	#
	# Step through file arguments
	#
	for file do
		trap "break" 2		# Intr to next file
		if [ ! -r $stem.D ]; then
			echo Data file $stem.D missing!
		else
			$Uncompress $stem.D | egrep $file | sed -f $sed.B
		fi
	done
	trap "rm -f $sed.?; exit 1" 2 3		# Restore global intr behavior
done
# Cleanup
rm -f $sed.?
exit 0
#
# End
#
