#! /bin/sh
#
#	storetape - store backup tape list in backups data base
#
#	Usage: storetape -t tape_name -l dump_level -d file_system
#		[-f input_file]
#	If input_file is not given, then standard input is read.
#	Input must be a list of file names.
#
Usage="Usage: $0 [-f file] -t tape_name -l dump_flags -d file_system"
if [ $# -lt 6 ]; then
	echo $Usage
	exit 1
fi

Compressor=compress		# CONFIG
FileSystem=""
TapeName=""
DumpFlags=""
InputFile=""

#
#	Parse arguments
#
argx=""
for a do
	case $a in
	-d* || -t* || -l* || -f*)
		argx=$a
		;;
	-*)
		echo Unknown argument $a
		exit 1
		;;
	*)
		case "$argx" in
		-d) 	FileSystem=$a ;;
		-t)	TapeName=$a ;;
		-l)	DumpFlags=$a ;;
		-f)	InputFile=$a ;;
		*)	echo $Usage; exit 1 ;;
		esac
		argx=""
	esac
done

#
# Generate backup data base filename
#
fslabel=`echo $FileSystem | tr -d /`			# Remove slashes
dbname=$fslabel.$DumpFlags				# Generate name

#
# Generate control file 
#
cat > $dbname.C <<!
$dbname
$FileSystem
$TapeName
$DumpFlags
`date`
!
#
# Compact input data into data base
#
(if [ -n "$InputFile" ]; then
	cat $InputFile 
else
	cat
fi) | $Compressor -c  > $dbname.D 2>/dev/null
chmod 0644 $dbname.?
exit 0
#
# End
#
