/*
 * dumptab -- read the dumptab file
 *
 * Dumptab provides a set of routines similar in spirit to getpwent(3).
 * getdtent() returns a pointer to a dumptab entry, getdtnam(name) returns
 * a dumptab entry pointer for the named filesystem, getdtpos(position)
 * returns a dumptab entry pointer for the filesystem at the indicated
 * tape position, setdtent opens the dumptab file, and enddtent closes it.
 *
 * Written by Paul Pomes, University of Illinois, Computing Services Office
 * Copyright 1985 by Paul Pomes and University of Illinois Board of Trustees
 *
 * This program may be freely reproduced and distributed provided the
 * copyright above is included in all copies.  It may not be included
 * in any software product or distribution sold for profit without the
 * permission of the author.
 *
 * UUCP:	{ihnp4,pur-ee,convex}!uiucdcs!uiucuxc!paul
 * ARPANET:	paul%uiucuxc@uiuc.arpa
 * CSNET:	paul%uiucuxc@uiuc.csnet
 * US Mail:	Univ of Illinois, CSO, 1304 W Springfield Ave, Urbana, IL  61801
 *
 * $Log:	dumptab.c,v $
 * Revision 1.1  85/07/02  13:47:31  root
 * Initial revision
 * 
 */

#ifndef lint
static char	RcsId[] = "$Header: dumptab.c,v 1.1 85/07/02 13:47:31 root Exp $";
#endif

#include	<stdio.h>
#include	<dumptab.h>

static char *DUMPTAB = "/etc/dumptab";
static FILE *dtf = NULL;
static char line[BUFSIZ+1];
static struct dumptab dumptab;

setdtent()
{
	if (dtf == NULL)
		dtf = fopen(DUMPTAB, "r");
	else
		rewind(dtf);
}

enddtent()
{
	if (dtf != NULL) {
		(void) fclose(dtf);
		dtf = NULL;
	}
}

static char *
dtskip(p)
register char *p;
{
	while (*p && *p != ':' && *p != '\n')
		p++;
	if (*p)
		*p++ = 0;
	return(p);
}

struct dumptab *
getdtent()
{
	register char *p;

	if (dtf == NULL) {
		if ((dtf = fopen( DUMPTAB, "r" )) == NULL)
			return(0);
	}
	p = fgets(line, BUFSIZ, dtf);
	if (p == NULL)
		return(0);
	dumptab.dt_name = p;
	p = dtskip(p);
	dumptab.dt_position = atoi(p);
	p = dtskip(p);
	dumptab.dt_weekly = atoi(p);
	p = dtskip(p);
	dumptab.dt_comment = p;
	while (*p && *p != '\n')
		p++;
	*p = '\0';
	return(&dumptab);
}

struct dumptab *
getdtpos(num)
register num;
{
	register struct dumptab *p;

	setdtent();
	while ((p = getdtent()) && p->dt_position != num)
		;
	enddtent();
	return(p);
}

setdtfile(file)
char *file;
{
	DUMPTAB = file;
}

struct dumptab *
getdtnam(name)
char *name;
{
	register struct dumptab *p;

	setdtent();
	while ((p = getdtent()) && strcmp(name, p->dt_name))
		;
	enddtent();
	return(p);
}
