/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"tp.h"
#include	"tploc.h"
#include	"tpsys.h"

/*
 * _tpwloc writes one block of non-zero length to a character device.
 * It must take care of local restrictions.
 */

int
_tpwloc(tf, buf, size)
	TPFILE *tf;
	char *buf;
{
	register int sz;
	
#ifdef	NORMAL
	/* This is the VAX version (anything goes). */
	sz = write(tf->_tp_fildes, buf, size);
#endif	NORMAL

#ifdef	EVEN
	/* This is the PDP11/45 version (even block size). */
	/* if odd, write one char more */
	sz = write(tf->_tp_fildes, buf, size % 2 ? size + 1 : size);
	sz = (sz > size ? size : sz);
#endif	EVEN

#ifdef	SWAB
	/* Modified 12/30/84 gertjan */
	/* This is the Motorola version (bytes are swabbed). */
	{
		static char swab_buf[TP_MAXB];	/* too big for the stack */
		swab(buf, swab_buf, size);
		sz = write(tf->_tp_fildes, swab_buf, size);
	}
#endif	SWAB
	
	return sz;
}
