/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"tp.h"
#include	"tploc.h"
#include	"tpsys.h"

/*
 * _tprdloc reads one block from a character device.
 * It must take care of local restrictions.
 */

int
_tprdloc(tf, buf, size)
	TPFILE *tf;
	char *buf;
{
	int sz;
	
#ifdef	NORMAL
	/* This is the VAX version, anything goes. */
	sz = read(tf->_tp_fildes, buf, size);
#endif	NORMAL

#ifdef	EVEN
	/* This is the PDP version, even block size required. */
	{
		/* if odd, read one char more */
		char ch = buf[size];		/* save the original */
		sz = read(tf->_tp_fildes, buf, size % 2 ? size + 1 : size);
		sz = (sz > size ? size : sz);
		buf[size] = ch;			/* restore the original */
	}
#endif	EVEN

#ifdef	SWAB
	/* Modified 12/30/84 gertjan */
	/* This is the Motorola version (bytes are swabbed). */
	{
		static char swab_buf[TP_MAXB];	/* too big for the stack */
		sz = read(tf->_tp_fildes, swab_buf, size);
		swab(swab_buf, buf, size);
	}
#endif	SWAB

	return sz;
}
