/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"tp.h"
#include	"tpsys.h"

TPFILE *
tpopen(unit, nmdns, rwx)
	char *nmdns, *rwx;
{
	char *name = (char *)0;
	static TPFILE tflist[_TP_MOPEN];
	TPFILE *tf;

	for (tf = &tflist[0]; tf->_tp_fildes != 0; tf++)
		if (tf == &tflist[_TP_MOPEN-1])	{
			_tpopenerr(name, "too many tapes");
		}

	tf->_tp_unit = unit;
	tf->_tp_nmdns = nmdns;
	tf->_tp_rw = 'r';
	tf->_tp_x = ' ';
	while (*rwx)
	switch (*rwx++)	{
	case 'r':
		tf->_tp_rw = 'r';
		break;
	case 'w':
		tf->_tp_rw = 'w';
		break;
	case 'x':
		tf->_tp_x = 'x';
		break;
	default:
		_tpopenerr(name, "Bad option in tpopen");
		break;
	}
	tf->_tp_blkc = tf->_tp_mkc = tf->_tp_mc = tf->_tp_eof = 0;

	name = _tpname(tf);

	if (tf->_tp_rw == 'w')	{
		if ((tf->_tp_fildes = creat(name, 0666)) < 0)	{
			_tpopenerr(name, "cannot create");
		}
	}
       	else	{
	       	if ((tf->_tp_fildes = open(name, 0)) < 0)	{
	       		_tpopenerr(name, "cannot open");
		}
	}

	return tf;
}
