/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*	#define's which may require local modification */


/*	1.	System code */
/*	This string of at most 13 characters will be written in the
	HDR1-label, to identify the system (organization) of origin.
	DO USE YOURS!
*/
/* Ruler for length:	"1234567890123"	*/
#define	SYSCODE		"VU, Amsterdam"


/*	2.	Names of tape devices */
/*	The macros DEV_* define the names of the low-density,
	normal-density and high-density tape devices, as double-strings.
	The first string indicates the read name, the second the write
	name; the unit number will be inserted at %d (using sprintf).
*/
#define	DEV_LOW		"/dev/rmt%d\0/dev/nrmt%d"
#define	DEV_NORMAL	"/dev/rmt8\0/dev/nrmt8"
#define	DEV_HIGH	"/dev/rmt%d\0/dev/nrmt%d"


/*	3.	Special reading and writing */
/*	The intricacies of reading and writing a block on tape are
	somewhat system-dependent.  #define exactly one of the following.
	
	If your system is not described by this (which will be rare),
	see  tprdloc.c, tpwloc.c and tpwtmloc.c  to see how to roll your own.
*/
#define	NORMAL	1		/* anything goes: VAX */
#undef	EVEN	1		/* only even blocksize allowed: PDP11 */
#undef	SWAB	1		/* bytes must be swapped: M 68000 */

