/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	<stdio.h>
#include	"aux.h"
#include	"tp.h"
#include	"tpsys.h"

FILE *tperr = stderr;

tperrout(stream)
	FILE *stream;
{
	tperr = stream;
	setbuf(tperr, (char *)NULL);
}

_tpopenerr(name, msg)
	char *name, *msg;
{
	if (name != NULL)
		fprintf(tperr, "%s: ", name);
	fprintf(tperr, "%s\n", msg);
	exit(1);
}

_tprwerr(msg, tf)
	char *msg;
	TPFILE *tf;
{
	fprintf(tperr,
		"After %d tape mark%s, after %ld block%s: %s on %s\n",
		english(tf->_tp_mkc), english(tf->_tp_blkc), msg, _tpname(tf));
}
