/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*	This file declares the routines that interface to the operating
	system beside those that do tape I/O.
	
	sysdate()	returns a transient pointer to today's date in the
			format YYDDD, e.g. 86365 for the last day of 1986.
	username()	returns a transient pointer to a readable form of
			the name of the user/owner. At most 14 chars will
			be used.
*/

#include	"aux.h"

#include	<sys/types.h>
#include	<pwd.h>
#include	<time.h>

extern time_t time();
extern struct tm *localtime();
extern struct passwd *getpwuid();
extern char *sprintf();

char * /* transient */
sysdate()	{			/* today's date as YYDDD */
	time_t tnow = time((time_t*)0);
	struct tm *timeptr = localtime(&tnow);
	static char today[6];
	
	VOID(sprintf(today, "%02d%03d",
				timeptr->tm_year, timeptr->tm_yday+1));
	return today;
}

char * /* transient */
username()	{		/* user name, if available, else NULL */
	struct passwd *pwd = getpwuid(getuid()); /* is transient already */
	
	return pwd == ((struct passwd *)0) ? ((char *)0) : pwd->pw_name;
}

