/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*
 * Name: survey, survey contents of magtape
 * Version: 820314
 */

#define	MSGUSE	"Usage is: survey [-cfhlmpx]\n"

#include	<stdio.h>
#include	"aux.h"
#include	"tp.h"
#include	"etoa.h"

#define	WIDTH	64

int unit = 0;
char *nmdns = TP_DENN;
char *rx = "r";
TPFILE *tf;
char buff[TP_MAXB];
int size;

char pflag = 0;

main(argc, argv)
	char *argv[];
{
	argc--, argv++;
	while (argc > 0 && argv[0][0] == '-')	{
		char *pp = argv[0];
		
		while (*++pp)	{
			switch (*pp)	{
			/* insert cases to handle the standard options */
#include	"options.h"
			/* special options */
			case 'p':
				pflag = 1;
				break;
			case 'x':
				rx = "rx";
				break;
			}
		}
		argc--, argv++;
	}

	if (argc != 0)
		goto Lbad;

	tf = tpopen(unit, nmdns, rx);

	while ((size = tpread(tf, buff, TP_MAXB)) >= 0)	{
		printf("%6d", size);
		if (pflag)
			expose();
		printf("\n");
	}
	exit(0);

Lbad:
	fprintf(stderr, MSGUSE);
	exit(1);
}

int
hex(ch)	{
	return "0123456789ABCDEF"[ch&017];
}

int
printable(ch)
	char ch;
{
	int i = char2int(ch);			/* 8 bits only */
	
	return is_ascii95(i) ? i : '?';
}

expose()	{
	if (size == 0)
		printf("\t* * * TAPE MARK * * *\n");
	else	{
		int i;
		printf("\t");
		for (i = 0; i < WIDTH && i < size; i++)	{
			printf("%c", printable(buff[i]));
		}
		printf("\n  EBC:\t");
		for (i = 0; i < WIDTH && i < size; i++)	{
			printf("%c", printable(ebc2asc(buff[i])));
		}
		printf("\n  HEX:\t");
		for (i = 0; i < WIDTH/2 && i < size; i++)	{
			char ch = buff[i];
			printf("%c%c", hex(ch>>4), hex(ch));
		}
		printf("\n");
	}
}

