/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*	Having a chunk out of a switch statement as a separate include
	file is unusual, but this file does implement a conceptual unit:
	the handling of the standard command line options for describing
	a generalized magtape.  See mag.1.
	
	This include file assumes
		aux.h		to be included
		tp.h		idem
	uses and updates
		argc		as supplied by main()
		argv		idem
	sets
		unit		the unit number
		nmdns		file name or density
	and jumps to
		Lbad		on bad command line parameters
*/

	default:
		goto Lbad;
	case 'c':			/* character device */
		unit = TP_CDEV;
		if (argc < 2)
			goto Lbad;
		nmdns = argv[1];
		argc--, argv++;
		break;
	case 'f':			/* tape image */
		unit = TP_IMAG;
		if (argc < 2)
			goto Lbad;
		nmdns = argv[1];
		argc--, argv++;
		break;
	case 'h':			/* high density */
		nmdns = TP_DENH;
		break;
	case 'l':			/* low density */
		nmdns = TP_DENL;
		break;
	case 'm':			/* unit number (real tape unit) */
		if (argc < 2)
			goto Lbad;
		if (!is_digit(argv[1][0]))
			goto Lbad;
		unit = atoi(argv[1]);
		argc--, argv++;
		break;
