/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*	To convert from EBCDIC to Ascii you need the table
	USASCII-8 TO EBCDIC-8 CORRESPONDENCE rather than the reverse,
	which strikes me as kind of counterintuitive.
	
	This table is Table 4 from
	Communications of the ACM, Vol 11, #11, Nov 1968, p 787.
*/

#define	S(c,r)	(c<<4) + r	/* implements the C/R convention */

char _etoa[] =	{		/* to be used in ebc2asc() */
	/* col 0 */
	S( 0, 0), S( 0, 1), S( 0, 2), S( 0, 3),
	S( 9,12), S( 0, 9), S( 8, 6), S( 7,15),
	S( 9, 7), S( 8,13), S( 8,14), S( 0,11),
	S( 0,12), S( 0,13), S( 0,14), S( 0,15),
	/* col 1 */
	S( 1, 0), S( 1, 1), S( 1, 2), S( 1, 3),
	S( 9,13), S( 8, 5), S( 0, 8), S( 8, 7),
	S( 1, 8), S( 1, 9), S( 9, 2), S( 8,15),
	S( 1,12), S( 1,13), S( 1,14), S( 1,15),
	/* col 2 */
	S( 8, 0), S( 8, 1), S( 8, 2), S( 8, 3),
	S( 8, 4), S( 0,10), S( 1, 7), S( 1,11),
	S( 8, 8), S( 8, 9), S( 8,10), S( 8,11),
	S( 8,12), S( 0, 5), S( 0, 6), S( 0, 7),
	/* col 3 */
	S( 9, 0), S( 9, 1), S( 1, 6), S( 9, 3),
	S( 9, 4), S( 9, 5), S( 9, 6), S( 0, 4),
	S( 9, 8), S( 9, 9), S( 9,10), S( 9,11),
	S( 1, 4), S( 1, 5), S( 9,14), S( 1,10),
	/* col 4 */
	S( 2, 0), S(10, 0), S(10, 1), S(10, 2),
	S(10, 3), S(10, 4), S(10, 5), S(10, 6),
	S(10, 7), S(10, 8), S( 5,11), S( 2,14),
	S( 3,12), S( 2, 8), S( 2,11), S( 2, 1),
	/* col 5 */
	S( 2, 6), S(10, 9), S(10,10), S(10,11),
	S(10,12), S(10,13), S(10,14), S(10,15),
	S(11, 0), S(11, 1), S( 5,13), S( 2, 4),
	S( 2,10), S( 2, 9), S( 3,11), S( 5,14),
	/* col 6 */
	S( 2,13), S( 2,15), S(11, 2), S(11, 3),
	S(11, 4), S(11, 5), S(11, 6), S(11, 7),
	S(11, 8), S(11, 9), S( 7,12), S( 2,12),
	S( 2, 5), S( 5,15), S( 3,14), S( 3,15),
	/* col 7 */
	S(11,10), S(11,11), S(11,12), S(11,13),
	S(11,14), S(11,15), S(12, 0), S(12, 1),
	S(12, 2), S( 6, 0), S( 3,10), S( 2, 3),
	S( 4, 0), S( 2, 7), S( 3,13), S( 2, 2),

	/* col 8 */
	S(12, 3), S( 6, 1), S( 6, 2), S( 6, 3),
	S( 6, 4), S( 6, 5), S( 6, 6), S( 6, 7),
	S( 6, 8), S( 6, 9), S(12, 4), S(12, 5),
	S(12, 6), S(12, 7), S(12, 8), S(12, 9),
	/* col 9 */
	S(12,10), S( 6,10), S( 6,11), S( 6,12),
	S( 6,13), S( 6,14), S( 6,15), S( 7, 0),
	S( 7, 1), S( 7, 2), S(12,11), S(12,12),
	S(12,13), S(12,14), S(12,15), S(13, 0),
	/* col A */
	S(13, 1), S( 7,14), S( 7, 3), S( 7, 4),
	S( 7, 5), S( 7, 6), S( 7, 7), S( 7, 8),
	S( 7, 9), S( 7,10), S(13, 2), S(13, 3),
	S(13, 4), S(13, 5), S(13, 6), S(13, 7),
	/* col B */
	S(13, 8), S(13, 9), S(13,10), S(13,11),
	S(13,12), S(13,13), S(13,14), S(13,15),
	S(14, 0), S(14, 1), S(14, 2), S(14, 3),
	S(14, 4), S(14, 5), S(14, 6), S(14, 7),
	/* col C */
	S( 7,11), S( 4, 1), S( 4, 2), S( 4, 3),
	S( 4, 4), S( 4, 5), S( 4, 6), S( 4, 7),
	S( 4, 8), S( 4, 9), S(14, 8), S(14, 9),
	S(14,10), S(14,11), S(14,12), S(14,13),
	/* col D */
	S( 7,13), S( 4,10), S( 4,11), S( 4,12),
	S( 4,13), S( 4,14), S( 4,15), S( 5, 0),
	S( 5, 1), S( 5, 2), S(14,14), S(14,15),
	S(15, 0), S(15, 1), S(15, 2), S(15, 3),
	/* col E */
	S( 5,12), S( 9,15), S( 5, 3), S( 5, 4),
	S( 5, 5), S( 5, 6), S( 5, 7), S( 5, 8),
	S( 5, 9), S( 5,10), S(15, 4), S(15, 5),
	S(15, 6), S(15, 7), S(15, 8), S(15, 9),
	/* col F */
	S( 3, 0), S( 3, 1), S( 3, 2), S( 3, 3),
	S( 3, 4), S( 3, 5), S( 3, 6), S( 3, 7),
	S( 3, 8), S( 3, 9), S(15,10), S(15,11),
	S(15,12), S(15,13), S(15,14), S(15,15)
};

