/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*
 * Name: cptp, copy tape
 * Version: 820314
 *
 * `Cptp' converts between real tapes and tape images on disk.
 */

#define	MSGUSE	"Usage is: cptp [-cfhlmx] [of=file | if=file]"

#include	<stdio.h>
#include	"aux.h"
#include	"tp.h"

int unit = 0;
char *nmdns = TP_DENN;
char *rx = "r";
TPFILE *from, *to;
char *filename;
int size;
char buff[TP_MAXB];

main(argc, argv)
	char *argv[];
{
	char *arg;

	argc--, argv++;
	while (argc > 0 && argv[0][0] == '-')	{
		char *pp = argv[0];
		
		while (*++pp)	{
			switch (*pp)	{
			/* insert cases to handle the standard options */
#include	"options.h"
			/* special options */
			case 'x':
				rx = "rx";
				break;
			}
		}
		argc--, argv++;
	}
	if (argc != 1)
		goto Lbad;
	arg = argv[0];
	if (arg[0] == '\0' || arg[1] != 'f' || arg[2] != '=')
		goto Lbad;
	filename = &arg[3];
	
	tperrout(stdout);
	switch (arg[0])	{
	case 'o':
		if (open(filename, 0) > 0)
			error("Output file already exists");
		from = tpopen(unit, nmdns, rx);
		to = tpopen(TP_IMAG, filename, "w");
		break;
	case 'i':
		from = tpopen(TP_IMAG, filename, "r");
		to = tpopen(unit, nmdns, "w");
		break;
	default:
		goto Lbad;
	}

	while ((size = tpread(from, buff, TP_MAXB)) >= 0)	{
		if (size == TP_MAXB)
			printf("Block too long; information may be lost\n");
		tpwrite(to, buff, size);
	}
	tpclose(from);
	tpclose(to);
	exit(0);

Lbad:
	error(MSGUSE);
	exit(1);
}

error(str)
	char *str;
{
	fprintf(stderr, "%s\n", str);
	exit(1);
}
