/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	<stdio.h>

extern char *strcpy();

#define	NL	'\n'
#define	TAB	'\t'
#define	SP	' '
#define	EOS	'\0'

#define	TRUE	1
#define	FALSE	0

#define	MAXSTR	128

/*
 * It is tempting to use structs for the declaration of the label data
 * structures, access the fields through selectors and let the C-compiler
 * do the offset calculation. There are, however, two problems:
 *    1. alignment is different on different machines (VAX vs. PDP11),
 *    2. according to the book the fields may even be arranged in inverse
 *       order.
 * So structs are out and defines are in.
 * A field is implemented as a pair: an address and a length.
 */

/* the general fields */
#define	Whole(p)	&(p)[0], sizeof (p)
#define	Labidf(p)	&(p)[0], 4

/* the VOL1 label */
#define	Volidf(p)	&(p)[4], 6
#define	Volacc(p)	&(p)[10], 1
#define	Sp1(p)		&(p)[11], 26
#define	Ownidf(p)	&(p)[37], 14
#define	Sp2(p)		&(p)[51], 28
#define	Labvers(p)	&(p)[79], 1

/* dates */
#define	Sp(p)		&(p)[0], 1
#define	Date(p)		&(p)[1], 5
#define	Yr(p)		&(p)[1], 2
#define	Yd(p)		&(p)[3], 3

/* the HDR1 label */
#define	Fileidf(p)	&(p)[4], 17
#define	Filesetidf(p)	&(p)[21], 6
#define	Filsecnum(p)	&(p)[27], 4
#define	Filseqnum(p)	&(p)[31], 4
#define	Gennum(p)	&(p)[35], 4
#define	Genversnum(p)	&(p)[39], 2
#define	Creatdate(p)	&(p)[41], 6
#define	Expirdate(p)	&(p)[47], 6
#define	Fileacc(p)	&(p)[53], 1
#define	Blkcount(p)	&(p)[54], 6
#define	Syscode(p)	&(p)[60], 13
#define	Sp3(p)		&(p)[73], 7

/* the HDR2 label */
#define	Recformat(p)	&(p)[4], 1
#define	Blklength(p)	&(p)[5], 5
#define	Reclength(p)	&(p)[10], 5
#define	Syssoftw(p)	&(p)[15], 35
#define	Bufoffset(p)	&(p)[50], 2
#define	Sp4(p)		&(p)[52], 28

/* the USRn label */
#define	Contents(p)	&(p)[4], 76


extern int unit;
extern char *nmdns;
extern TPFILE *tf;

#define	ASK_NO	0	/* use default and check */
#define	ASK_YES	1	/* ask and check */
#define	ASK_SUG	2	/* suggest default and check */
#define	ASK_ERR	3	/* ask again and check */

/*	Macros to define an additional control structure to handle
	interactive input, under the presence of user errors.
*/
#define	inmood(md)	{int mood = md; for (;;mood=ASK_ERR)
#define	iferr(cond)	if(cond){print_loc();
#define	enderr		continue;}
#define	endmood		break;}

extern char *sps2txt(), *str2txt(), *expl2str(), *tty_line(), *tty_str();
extern char *enq_str(), *fld2str(), *char2str();
extern int enq_int(), isascstr(), fld2int();
extern fld2fld(), str2fld(), prf_s(), errors();

struct format	{
	char type;
	int (*checkpar)();
	int (*cpblk)();
};

extern struct format formats[];
extern struct format *format_of_type();

extern char filename[MAXSTR];
extern FILE *file;
extern int filseqnum;
extern int filsecnum;
extern char rectype[1];
extern struct format *recformat;
extern int blklength;
extern int reclength;
extern int bufoffset;
extern int reccount;
extern int blkcount;

extern char VOL1buf[80];
extern char HDR1buf[80];
extern char HDR2buf[80];
