/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

#include	"aux.h"
#include	"tp.h"
#include	"ansi.h"

extern char *sprintf();

int unit = 0;
char *nmdns = TP_DENN;
TPFILE *tf = NULL;

char filename[MAXSTR];
FILE *file = NULL;
int filseqnum = 0;
int filsecnum = 1;
char rectype[1] = 'F';
struct format *recformat;
int blklength = 1920;
int reclength = 80;
int bufoffset = 0;
int reccount;
int blkcount;

char VOL1buf[80];
char HDR1buf[80];
char HDR2buf[80];

char *
sps2txt(p)	{
	return p == 0 ? "<empty>" : p == 1 ? "<space>" : "<spaces>";
}

char *
str2txt(s)
	char *s;
{
	int p = 0;

	while (s[p] != EOS)	{
		if (s[p] != SP)
			return s;
		p++;
	}
	return sps2txt(p);
}

/* An expl(anation) is an explanatory string which contains the name of the
 * object being explained as the first item between ` and ' . The expl may
 * contain one %s which is replaced by the default (string) value.
 */

char * /* transient */
expl2str(expl)
	char *expl;
{
	static char str[MAXSTR];
	char *nm = expl, cnt = 0;
	
	while (*nm != EOS && *nm != '`')	{
		nm++;
	}
	nm++;
	while (*nm != EOS && *nm != '\'')	{
		if (cnt < MAXSTR-1)
			str[cnt++] = *nm;
		nm++;
	}
	str[cnt] = EOS;
	return str;
}

char * /* transient */
tty_line()	{
	static char ans[MAXSTR];
	int cnt = 0;
	int ch;

	while ((ch = getchar()) != NL)	{
		if (ch == EOF)
			errors("\n*** No interaction!!!");
		if (cnt < MAXSTR-1)
			ans[cnt++] = ch;
	}
	ans[cnt] = EOS;
	return ans;
}

char * /* transient */
tty_str(prompt, expl, md, def)
	char *prompt, *expl, md, *def;
{
	static char conversation = FALSE;
	char *str;
	int err = 0;

	if (!conversation)	{
		prf_s("\n\
	I shall have to ask some questions; to get more information,\n\
	answer a question with a single question mark (?).\n\n", "");
		conversation = TRUE;
	}
	while (err < 3)	{
		printf(prompt, expl2str(expl));
		str= tty_line();
		if (strcmp(str, "?") == 0)	{
			printf("\n");
			prf_s(expl, def);
			printf("\n");
		}
		else
		if (strlen(str) > 0)
			return str;
		else
		if (md == ASK_SUG)
			return NULL;
		else	{
			printf("I do need an answer!\n");
			err++;
		}
	}
	errors("\nSorry");
	return str;
}

char * /* transient */
enq_str(expl, md, def)
	char *expl, *def;
{
	char *str;

	switch (md)	{
	case ASK_NO:
		str = def;
		break;
	case ASK_YES:
		print_loc();
		str = tty_str("Please type your %s: ", expl, md, def);
		break;
	case ASK_SUG:
		print_loc();
		printf("Default %s: ", expl2str(expl));
		prf_s("%s\n", str2txt(def));
		str = tty_str("Please type a new %s, or press RETURN: ",
			expl, md, def);
		if (str == NULL)
			str = def;
		break;
	case ASK_ERR:
		str = tty_str("Please type a new %s: ", expl, md, def);
		break;
	}

	return str;
}

int
enq_int(expl, md, def, max)
	char *expl;
{
	int res;
	char deftxt[MAXSTR];

	VOID(sprintf(deftxt, "%d", def));
	inmood (md)	{
		char *str = enq_str(expl, mood, deftxt);
		char *ptr = str;
		char ch;

		res = 0;
		while ((ch = *ptr++) != EOS)	{
			int dig = char2int(ch) -'0';

			if (dig < 0 || dig > 9)	{
				res = -1;
				break;
			}
			if (res > max/10 || res*10 > max - dig)	{
			/* airtight, waterproof and overflow-resistant */
				res = -2;
				break;
			}
			res = res*10 + dig;
		}
		iferr (res == -1)	{
			printf("The %s `%s' is not numeric\n",
					expl2str(expl), str);
			enderr;
		}
		iferr (res == -2)	{
			printf("The %s `%s' is too large\n",
					expl2str(expl), str);
			printf("The maximum value is %d\n", max);
			enderr;
		}
		endmood;
	}
	return res;
}

int
isascstr(str)
	char *str;
{
	char ch;

	while ((ch = *str++) != EOS)
		if (!is_ascii95(ch))
			return FALSE;
	return TRUE;
}

int
fld2int(addr, size)
	char *addr;
{
	int res = 0, i;

	for (i = 0; i < size; i++)	{
		char ch = addr[i];
		int dig = char2int(ch) - '0';
		
		if (ch == SP)
			continue;
		if (dig < 0 || dig > 9)
			return -1;
		res = res * 10 + dig;
	}
	return res;
}

char * /* transient */
fld2str(addr, size)
	char *addr;
{
	static char str[MAXSTR];
	int i;

	for (i = 0; i < size; i++)
		if (i < MAXSTR-1)
			str[i] = addr[i];
	while (i > 0 && str[i-1] == SP)
		i--;
	str[i] = EOS;
	return str;
}

fld2fld(str, s1, addr, s2)
	char *str, *addr;
{
	if (s1 != s2)
		abort();
	while (s1-- > 0)
		*addr++ = *str++;
}

str2fld(str, addr, size)
	char *str, *addr;
{
	while (size-- > 0)
		*addr++ = *str != EOS ? *str++ : SP;
}

char * /* transient */
char2str(ch)	{
	static char buff[7];

	if (is_ascii95(ch))
		VOID(sprintf(buff, "%c", ch));
	else
		VOID(sprintf(buff, "\\[%03o]", char2int(ch)));
	return buff;
}

/*
 * `prf_s' prints a possibly ugly string `s' under a format `f' that may
 * be so long that it normally blows up the `printf' routine.
 */
prf_s(f, s)
	char *f, *s;
{
	char fch;

	while ((fch = *f++) != EOS)	{
		if (fch != '%')
			putchar(fch);
		else	{
			int sch;

			f++;
			while ((sch = *s++) != EOS)
				printf("%s", char2str(sch));
		}
	}
}

errors(str)
	char *str;
{
	printf("%s\n", str);
	if (tf != NULL)
		tpclose(tf);
	exit(1);
}

struct format *
format_of_type(ch)
	char ch;
{
	struct format *fm;

	for (fm = &formats[0]; fm->type != EOS; fm++)
		if (fm->type == ch)
			return fm;
	return NULL;
}
