/*	This file is part of the magtape handling package MAG.
	Written by Dick Grune, Vrije Universiteit, Amsterdam.
*/

/*
 * Name: NOSsplit, split Cyber system tape (data format is SI)
 * Version: 820314
 */

#define	MSGUSE	"Usage is: NOSsplit [-cfhlm[s N]] [out_name]\n"

#include	<stdio.h>
#include	"aux.h"
#include	"tp.h"
extern char *sprintf();

#define	MINSIZE	6			/* smaller is a noise block */
#define	BSIZE	3840			/* blocksize binary files */
#define	CSIZE	960			/* blocksize coded files */
#define	SIZE	3840			/* maximum blocksize */
#define	EORM	"\055\023\035\052\027\054\000"
#define	EORL	7
#define	EOS	'\0'

#define	lastblock(n)	((n)!=BSIZE && (n)!=CSIZE)
#define	cybln(n)	((n)*8/60*10)

int fnumber = 0;
char *ofil = "x";
char fname[128];
FILE *outf;

char buff[SIZE];
int size;	/* number of chars in `buff' */
int bpos;	/* number of bits consumed by `get6bits' */
int bstat;

int unit = 0;
int skipf = 0;		/* number of logical records to skip (forwards) */
char *nmdns = TP_DENN;
TPFILE *tf;

char *progname;

main(argc, argv)
	char *argv[];
{
	progname = argv[0];
	argc--, argv++;

	while (argc > 0 && argv[0][0] == '-')	{
		char *pp = argv[0];
		
		while (*++pp)	{
			switch (*pp)	{
			/* insert cases to handle the standard options */
#include	"options.h"
			/* special options */
			case 's':
				if (argc < 2)
					goto Lbad;
				if (!is_digit(argv[1][0]))
					goto Lbad;
				skipf = atoi(argv[1]);
				argc--, argv++;
				break;
			}
		}
		argc--, argv++;
	}

	if (argc == 1)	{
		ofil = argv[0];
		argc--, argv++;
	}

	if (argc != 0)
		goto Lbad;

	read_tape();
	exit(0);

Lbad:
	fprintf(stderr, MSGUSE);
	exit(1);

}

read_tape()	{
	int i;
	int bcnt;

	tperrout(stdout);
	tf = tpopen(unit, nmdns, "rx");

	fillbuff();
	if (size == 80 && strncmp(buff, "VOL1", 4) == 0)	{
		printf("This is a labelled tape\n");
		printf("For label information use `ansir -pn'\n");
		while (size > 0)
			fillbuff();
		if (size == 0)
			fillbuff();
	}
	else	printf("This is a non-labelled tape\n");

	for (i = 0; i < skipf; i++)	{
		if (size <= 0)	{
			printf("%d record%s missing\n", english(skipf-i));
			exit(1);
		}
		fnumber++;
		while (!lastblock(size))
			fillbuff();
		fillbuff();
	}

	if (skipf > 0)
		printf("%d logical record%s skipped\n", english(skipf));

	while (size > 0)	{
		newcreat(fnumber++);

		bcnt = 1;
		while (putbuff(cybln(size)), !lastblock(size))	{
			fillbuff();
			bcnt++;
		}

		proc_eor(bcnt);

		VOID(fclose(outf));
		outf = NULL;
		fillbuff();
	}

	printf("%d record%s retrieved\n", english(fnumber-skipf));
}

newcreat(fn)	{
	int i;

	for (i=0; ofil[i] != EOS; i++)
		fname[i] = ofil[i];
	VOID(sprintf(&fname[i], "%04d", fn));
	outf = fopen(fname, "w");
	if (outf == NULL)	{
		printf("%s: cannot create `%s'\n", progname, fname);
		exit(1);
	}
}

fillbuff()	{

	do	size = tpread(tf, buff, sizeof buff);
	while (size > 0 && size < MINSIZE /* noise record */);
	bpos = bstat = 0;
}

putbuff(n)
	int n;				/* number of 6bit chars */
{

	while (n-- > 0)
		putc(get6bits(), outf);
}


proc_eor(bcnt)	{
	char eor[EORL];
	int i;

	for (i = 0; i < EORL; i++)
		eor[i] = get6bits();

	printf("%s: ", fname);
	printf("%d block%s, ", english(bcnt));
	if (strncmp(eor, EORM, EORL) != 0)
		printf("no proper EOR\n");
	else
		printf("EOR%2o\n", get6bits());
}

#define	left(c,n)	(((c)&((077<<(8-(n)))&0377))>>(8-(n)))
#define	right(c,n)	(((c)&((077>>(6-(n)))&0377))<<(6-(n)))
/*
 * These forms are constructed through program transformations; the
 * author cannot, by any stretch of imagination, guess why they work.
 */

int
get6bits()	{
	int res = 0;

	switch (bstat++)	{
	case 0:	res = left(buff[bpos+0], 6);
		break;
	case 1:	res = right(buff[bpos+0], 2) + left(buff[bpos+1], 4);
		break;
	case 2:	res = right(buff[bpos+1], 4) + left(buff[bpos+2], 2);
		break;
	case 3:	res = right(buff[bpos+2], 6);
		break;
	}
	if (bstat == 4)	{
		bpos += 3;
		bstat = 0;
	}
	return res;
}
