.TH EXETOC 1L "27 Oct 1989"
.SH NAME
exetoc \- Manage a table of contents on an Exebyte 2GB tape cartridge.
.SH SYNOPSIS
.B exetoc
.BI [-t tape ]
.BI [-g file ]
.BI [-p file ]
.B  [-i]
.B  [-v]
.B  [-q]
.SH DESCRIPTION
.B Exetoc is a program that allows you to write a table of contents
file onto the front of a 2GB helical scan tape, read it back later, 
and update it without disturbing the other contents of the tape.  
.PP
It does this by reserving a fixed amount of space at the start of 
the tape (about 10 megabytes in the current implementation) that can be 
used to store information about the contents of the tape.  About 2 
megabytes of this space is available for keeping the table of
contents.  The rest acts as a buffer space between the end of the table 
of contents and the first data file on the tape.
.SH OPTIONS
.B Exetoc understands the following options:
.TP
.BI -t tapedrive
Sets the tape drive name to something other than the default, which
is derived by looking for the environment variable EXETOC, or using
"/dev/rsmt0" if the environment variable is not set.  Exetoc is normally 
linked with the remote tape library, allowing you to use 
names of the form \fIhost:device\fP for direct access to remote tape 
drives.
.TP
.BI -g file
Gets the table of contents from the tape and places a copy of
it into the named file.  If \fIfile\fP is given as -, the table of 
contents is copied to standard output.
.TP
.BI -p file
Puts a table of contents onto the tape.  The contents of the table
are taken from the named file, or from standard input if \fIfile\fP
is given as -.  This flag may be used to create and rewrite tables
of contents.
.TP
.B -i
Initializes a tape by creating a blank table of contents at the
front of the tape.  You must initialize a tape with the -i flag before
you can write a table of contents onto it for the first time.
.TP 
.B -v
Verifies that the tape in the tape drive has previously been initialized
with exetoc -i.
.TP
.B -q
Causes the program to work more quietly than it otherwise would.
.LP
Any other option causes exetoc to deliver a lengthy message explaining
the legal flags.
.SH "ENVIRIONMENT VARIABLES"
.TP
EXEBYTE
Specifies the default tape drive to use.  Exetoc is normally linked
with the remote tape library, allowing you to use names of the form
\fIhost:device\fP for direct access to remote tape drives.
.SH "EXIT STATUS"
Exetoc exits with one of the following well-defined status codes:
.TP
0
indicates successful completion of an operation.
.TP
1
indicates an error in usage (illegal command line flag, for instance).
.TP
2
indicates an I/O error of some kind.  A diagnostic message is printed
on standard error in this case, explaining what the error was.
.TP
3
indicates that a read, write, or verify operation was attempted with a 
tape that has never been initialized to hold a table of contents.
.TP
4
indicates that the table of contents file you are trying to write onto
the tape is too large to fit.
.SH BUGS
The tape is rewound after \fIany\fP exetoc operation, even if the no-rewind
device was specified on the command line.
.SH "SEE ALSO"
.nf
dd(1), bdd(1), mt(1)
.SH AUTHOR
.nf
Matt Landau, BBN Systems and Technologies Corp.  (mlandau@bbn.com)
