#if !lint && !SABER
static char RcsId[] = "$Header: smtops.c,v 1.2 89/10/27 16:14:58 mlandau Exp $";
#endif

#include <stdio.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>

#if REMOTE
#include <rmt.h>
#endif

#include "exitcodes.h"
#include "smtops.h"


/****************************************************************************
 * BASIC MAGTAPE OPERATIONS FOR EXEBYTE DRIVES
 ***************************************************************************/


/*
 * smt_open():  Open a tape device.
 * 
 * Actually, it's just a wrapper around open, but data abstraction is 
 * good, right?
 */
 

int	smt_open(device, mode)
char	*device;
int	mode;
{   
    int	fd;
    
    if ((fd = open(device, mode)) < 0)
    {   
	perror(device);
	exit(EXIT_IO);
    }
    return (fd);
}


/* 
 * smt_close():  Close a tape device -- this is just a wrapper around close.
 */
 
void	smt_close(tapefd)
int	tapefd;
{   
    if (close(tapefd) < 0)
    {   
	perror("tape close");
	exit(EXIT_IO);
    }
}


/* 
 * smt_close_without_eof():  Rewind and close a tape device.
 * 
 * 	This routine provides a rewind-and-close operation, which is
 * 	necessary to prevent the tape device driver from adding an EOF
 * 	mark to the tape if the last operation before closing the device
 * 	was a write.  Since we are continutally rewriting the same file,
 *	we need to inform the driver that we don't want a new EOF mark
 * 	every time we do so.
 */
 
void	smt_close_without_eof(tapefd)
int	tapefd;
{   
    smt_rewind(tapefd);
    smt_close(tapefd);
}


/* 
 * smt_read():  Read from the tape drive
 * smt_write(): Write to the tape drive
 * 
 * 
 * 	This are wrappers around read and write.  They're mostly here
 * 	so that we can use the rmt library if we want to.
 */
 
int	smt_read(tapefd, buffer, count)
int	tapefd;
char	*buffer;
int	count;
{   
    return (read(tapefd, buffer, count));
}


int	smt_write(tapefd, buffer, count)
int	tapefd;
char	*buffer;
int	count;
{   
    return (write(tapefd, buffer, count));
}


/* 
 * smt_status():  Return the status of the tape drive.
 * 
 * This code is cribbed from the mts command.  The smt_stat structure
 * looks like this:
 * 
 * 	struct smt_stat
 * 	{
 * 		char   smt_type[8];	-- cartridge type
 *		u_long smt_remain;	-- KBytes left on tape
 *		u_long smt_size;	-- Total size of tape (KBytes)
 * 		u_long smt_ecc;		-- ECC numbers
 * 		long   smt_wp:1;	-- write protected?
 * 		long   smt_bot:1;	-- at beginning of tape?
 *	}
 */

struct smt_stat	*smt_status(tapefd)
int		 tapefd;
{   
    static struct smt_stat status;
    
    if (ioctl(tapefd, SMTIOGETSTAT, &status) < 0)
    {   
	perror("tape status");
	exit(EXIT_IO);
    }
    return (&status);
}



/* 
 * smt_rewind():  Rewind a tape and verify that it worked.
 */

void	smt_rewind(tapefd)
int	tapefd;
{   
    static struct mtop rewind_op = { MTREW, 1 };
    
    if (ioctl(tapefd, MTIOCTOP, &rewind_op) < 0)
    {   
	perror("tape rewind");
	exit(EXIT_IO);
    }
#if !REMOTE
    /* rmtlib.a does not like the custom ioctls used in the smt_status
       routine, so don't use it internally */
    if (!smt_status(tapefd)->smt_bot)
    {   
	fputs("Could not rewind tape for some unknown reason.");
	exit(EXIT_IO);
    }
#endif
}


/* 
 * smt_eof():  Write an EOF mark on the tape.
 * 
 * We will probably never need this, but it doesn't hurt to include it.
 */
 
void	smt_eof(tapefd)
int	tapefd;
{   
    static struct mtop eof_op = { MTWEOF, 1 };
    
    if (ioctl(tapefd, MTIOCTOP, &eof_op) < 0)
    {   
	perror("write eof");
	exit(EXIT_IO);
    }
}


