/*  4.2bsd multi-buffered screaming tape copy
    with streamer as input, output, or both.
    Does it all in user code via 2 concurrent processes,
    synchronized with flock().
    For streamer-to-streamer copies, NBUFS should be large (~10)
*/

#define NBUFS  2	/* Number of multi-buffers (hence processes) */

#include <errno.h>
#include <signal.h>
#include <sys/file.h>
#include <sys/wait.h>

int firstrd[2], prevrd[2], nextrd[2];	      /* File descriptors */
int firstwr[2], prevwr[2], nextwr[2];
int slavepid[NBUFS];
int bufsiz = 10240;
char *buf, *sbrk();

unsigned atou(s) register char *s; {	/* Parse digit string to unsigned int */
	register unsigned u = 0;
	while (*s >= '0' && *s <= '9')
		u = u*10 + (*s++ - '0');
	if (*s == 'b') u *= 512, s++;
	if (*s == 'k') u *= 1024, s++;
	return(*s == '\0' ? u : 0);
}

abort() {				/* Signal catchers */
	killall();
	_exit(EINTR);
}

done() {
	_exit(0);
}

main(argc,argv) int argc; char *argv[]; {
	register int i, pid;
	static int wstat, children = NBUFS;

	if (argc > 2 || argc == 2 && (bufsiz=atou(argv[1])) == 0) {
		static char usage[] = "Usage: stream [bufsiz][b|k]\n";
		write(2, usage, sizeof(usage)-1);
		_exit(EINVAL);
	}
	buf = sbrk(bufsiz);
	if (buf == (char *) -1) {
		perror("sbrk");
		_exit(ENOMEM);
	}
	if (signal(SIGINT, abort) == SIG_IGN)
		signal(SIGINT, SIG_IGN);
	if (signal(SIGTERM, abort) == SIG_IGN)
		signal(SIGTERM, SIG_IGN);

	lockpipe(firstrd);
	lockpipe(firstwr);
	for (i=0; i<NBUFS; ++i) {
		if (i == 0) {
			prevrd[0] = firstrd[1]; prevrd[1] = firstrd[0];
			prevwr[0] = firstwr[1]; prevwr[1] = firstwr[0];
		} else {
			prevrd[0] = nextrd[0];	prevrd[1] = nextrd[1];
			prevwr[0] = nextwr[0];	prevwr[1] = nextwr[1];
		}
		flock(prevrd[1], LOCK_EX);
		flock(prevwr[1], LOCK_EX);
		nextrd[0] = firstrd[0]; nextrd[1] = firstrd[1];
		nextwr[0] = firstwr[0]; nextwr[1] = firstwr[1];
		if ((i < NBUFS-1 && (lockpipe(nextrd)<0 || lockpipe(nextwr)<0))
				|| (slavepid[i]=fork()) < 0) {
			perror("stream: too many slaves (recompile smaller)");
			killall();
			_exit(EAGAIN);
		}
		if (slavepid[i] == 0) { 	    /* Slave starts up here */
			signal(SIGINT,SIG_IGN);
			signal(SIGTERM,done);	    /* exit cleanly */
			copier();
			_exit(0);
		}
		if (i > 0) {
			close(prevrd[0]); close(prevrd[1]);
			close(prevwr[0]); close(prevwr[1]);
		}
	}
	flock(firstrd[0], LOCK_UN);
	flock(firstwr[0], LOCK_UN);
	close(firstrd[0]);  close(firstrd[1]);
	close(firstwr[0]);  close(firstwr[1]);

	while (children > 0 && (pid=wait(&wstat)) > 0)
		for (i=0; i<NBUFS; i++)
			if (pid == slavepid[i]) {
				children--;
				slavepid[i] = 0;
				killall();
				if (wstat != 0) _exit(EIO);
			}
	_exit(0);
}

killall() {
	register int i;
	for (i=0; i<NBUFS; i++)
		if (slavepid[i] > 0) kill(slavepid[i], SIGTERM);
}

lockpipe(fd) int fd[2]; {	/* prefer pipe(), but flock() barfs on them */
	char tmpname[20];
	strcpy(tmpname, "/tmp/lockpipeXXXXXX");
	mktemp(tmpname);
	if ((fd[1]=creat(tmpname,0400)) < 0)
		return(fd[1]);
	fd[0] = open(tmpname, 0);
	unlink(tmpname);
	return(fd[0] < 0 ? fd[0] : 0);
}

/* Synchronization - each process has a lockfile, and shares file
 * descriptors to the following process's lockfile.  When our write
 * completes, we release our lock on the following process's lock-
 * file, allowing the following process to lock it and proceed. We
 * get the lock back for the next cycle by swapping descriptors.
 * Similarly for reads.
 */

#include <stdio.h>
copier() {
	register int nread, toggle = 0;

	flock(prevrd[toggle], LOCK_EX);
	while ((nread=read(0, buf, bufsiz)) > 0) {
		flock(nextrd[toggle^1], LOCK_UN); /* Jolt awake next reader */
		flock(prevwr[toggle], LOCK_EX);   /* Wait for previous write */
		if (write(1, buf, nread) != nread) {
			perror("stdout");
			_exit(1);
		}
		toggle ^= 1;
		flock(nextwr[toggle], LOCK_UN);   /* Jolt awake next writer */
		flock(prevrd[toggle], LOCK_EX);   /* Now wait for the read */
	}
	flock(prevwr[toggle], LOCK_EX);
	if (nread < 0) {
		perror("stdin");
		_exit(1);
	}
}
