/*
 * verify.c
 *
 * make sure beer is being run by the proper person.
 */

#include <stdio.h>
#include <pwd.h>

main (argc, argv)
int argc;
char **argv;
{
	struct passwd *ent, *getpwent ();

	if (argc != 2)
	{
		fprintf (stderr, "usage: %s login_name\n", argv[0]);
		exit (1);
	}

	if (getuid () == 0)		/* root can do what he wants */
		exit (0);
	else if (geteuid () != 0)
	{
		fprintf (stderr, "%s: not running setuid to root.\n", argv[0]);
		exit (2);
	}

	if ((ent = getpwent()) == NULL)
	{
		fprintf (stderr, "%s: can't read /etc/passwd.\n", argv[0]);
		exit (3);
	}
	else
	{
		do
		{
			if (strcmp (ent -> pw_name, argv[1]) == 0)
			{
				endpwent();
				if (getuid() == ent -> pw_uid)
					exit (0);
				else
					exit (4);
			}
		}
		while ((ent = getpwent()) != NULL);
	}

	endpwent();
	fprintf (stderr, "%s: '%s' is not in /etc/passwd.\n", argv[0], argv[1]);
	exit (4);
}
