.ie t \{ .de CW
.vs 10.5p
.ta 16m/3u 32m/3u 48m/3u 64m/3u 80m/3u 96m/3u
.nf
.ft CW
.cs CW 18
.. \}
.el \{ .de CW
.nf
.. \}
.ie t \{ .de CN
.ta 0.5i 1i 1.5i 2i 2.5i 3i 3.5i 4i 4.5i 5i 5.5i 6i
.vs
.fi
.cs CW
.ft
.. \}
.el \{ .de CN
.fi
.. \}
.if n .ds lq ""
.if n .ds rq ""
.if t .ds lq ``
.if t .ds rq ''
.nr PO 1i
.RP
.TL
Doing Backups with BEER
.AU
Arnold D. Robbins
.AI
School of Information and Computer Science
Georgia Institute of Technology
Atlanta, Georgia  30332
(404) 894-3658
.sp
arnold@gatech.{CSNET, UUCP}
.AB
.I Beer
is the Georgia Tech backup program for doing
.B B ackups
.B E asily,
.B E ffectively,
and
.B R eliably.
This document discusses using
.I beer
in day to day operation.
The manual page
.I beer (8)
should also be consulted.
.AE
.NH
INTRODUCTION
.PP
.I Beer
is a program designed for the management of full and
incremental file system backups of the Georgia Tech Unix machines.
Actual backups are done using the
.I bru (1)
program, which is not discussed here.
.I Beer
keeps track of which file systems are to be backed up,
when they are to be backed up, and which tapes are to be used
for any given backup.
It arranges to run
.I bru ;
the operator should not have to deal directly with
.I bru
when performing backups, other than to mount additional tapes.
.PP
.I Beer
does four kinds of backups: quarterly, monthly, weekly, and daily.
The quarterly backups are
.I full
dumps, i.e. every file on the machine
is dumped to tape.
These are usually done in single-user mode (only the
system console active); the procedure for doing
quarterly backups is described below.
.PP
All other backup types are
.I incremental .
In other words, only files which have been changed since a given time
are dumped to tape.
These are usually done while the system is in multi-user (normal) operation.
.NH
TAPE SET NAMING AND NUMBERING
.PP
Each different type of incremental backup has several sets of tapes.
Having numerous tapes allows for greater redundancy, increasing the
chances that there will be a recent copy of any given file on tape,
should a disk file accidentally be destroyed.
.PP
Tape sets are numbered with Roman numerals, (I, II, III, etc.).
Within the monthly and weekly tape sets the tapes
themselves are numbered with Arabic numerals (1, 2, 3, etc.).
The daily tapes are \*(lqnumbered\*(rq with
the names of the days of the week
(for instance, \*(lqMonday,\*(rq \*(lqTuesday,\*(rq etc.).
.I Beer
automatically keeps track of which tape set to use, asking for tapes
by tape number and tape set
(for example, \*(lqtape 1 from monthly set III,\*(rq
\*(lqTuesday's tape from weekly set II\*(rq).
The tapes in the tape cabinet will be labeled appropriately.
.NH
NORMAL USE (INCREMENTALS)
.PP
In normal, daily use,
.I beer
will select what kind of backup to do; daily, weekly, or monthly.
The operator should simply follow the defaults, which usually means
just hitting the RETURN or NEWLINE key.
.PP
To do backups, the operator should log in to the \*(lqoperator\*(rq
account, and issue the command:
.DS
.CW
% /etc/beer/beer
.CN
.DE
.I Beer
will produce the following prompt:
.DS
.CW
Please enter type of backup.
Only the first letter is significant.
Case is ignored.

Types of backups are:
	Quarterly
	Monthly
	Weekly
	Daily
Choice (default: d) ?
.CN
.DE
In this case, the default is
.B d
for
.B daily .
It will occasionally be
.B w
for
.B weekly ,
or
.B m
for
.B monthly .
.PP
Typing a RETURN or NEWLINE will cause
.I beer
to default to doing the daily backup. The operator may type one of the
other letters to do one of the other kinds of backups.
Typing a Control-D (End-of-file) will cause
.I beer
to exit.
Anything else will cause
.I beer
to re-issue the prompt and wait for a new response.
.PP
.I Beer
proceeds to find the files that should be
backed up to tape.
While it is finding files, it will print the message:
.DS
.CW
Finding files ....
.CN
.DE
When it has found the files, and saved the list in a temporary file,
it will so indicate by saying it is ready to dump the files to tape:
.DS
.CW
Finding files .... done. Ready to dump to tape.
.CN
.DE
.PP
Next,
.I beer
will double check that the default device is correct, with the
following prompt:
.DS
.CW
Enter device (default: /dev/rmt8):
.CN
.DE
.I Beer
indicates that the device to do backups on is the rewinding
tape drive.
Usually, the operator should just type RETURN to continue.
However, should the tape drive be broken, and the operator wish to
do backups on a remote system's tape drive, he should enter that
device name (e.g.
.if n \fBstratus:/dev/rmt8\fP).
.if t \f(CWstratus:/dev/rmt8\fP).
A Control-D can be used to exit,
or the RETURN key to just use the default.
.PP
When using a device other than the default,
.I beer
will ask what physical block size it should use.
In particular, on remote tape drives, the block size
should be no more than 10K.
.DS
.CW
Enter new block size (default: 20K)
.CN
.DE
The default is 20K blocks. Just type RETURN
to continue, or as always, an EOF to exit.
.PP
Finally,
.I beer
will prompt the operator to mount the first tape: (these are examples)
.DS
.CW
Put Tuesday's tape from daily tape set I on the drive.
Mount additional tapes when prompted by bru.
hit return when ready (EOF to exit):
.CN

	- or -

.CW
Put tape 1 of monthly tape set II on the drive.
Mount additional tapes when prompted by bru.
hit return when ready (EOF to exit):
.CN
.DE
The first prompt is an example of what
.I beer
prints for daily backups, while the second is what
.I beer
prints for weekly or monthly backups.
.PP
The operator should find the appropriate tape, and mount it on the
tape drive. The tape should have a write ring in it.
Once the tape is threaded properly, the \*(lqload\*(rq and
\*(lqon line\*(rq buttons should be pressed, in that order.
Then type RETURN on the terminal running
.I beer .
.PP
At this point
.I bru
will start to run.
For weekly and monthly backups,
it will probably require more than one tape.
In this case
.I bru
will prompt for the next
tape to be loaded.
Take the first tape off the drive, mount, thread, and load the next
tape, and then put the drive back on line. Then hit RETURN.
.I Bru
should continue its backups.
Put the current date on the tape label of the first tape,
to indicate when it was last
used for backups.
Repeat this procedure for each volume (tape) of the backup.
.NH
QUARTERLY BACKUPS
.PP
Quarterly backups are a little more involved than incremental backups.
Therefore, running
.I beer
is more complicated.
This sections discusses the procedures to follow, and some of the
reasons why the procedures are set up as they are.
.PP
Quarterlies are usually done in single-user mode, i.e., with no one
else using the system. This is to guarantee that the file systems are
quiescent (quiet), so that
.I bru
will be able to backup all the files, without worrying that someone may
be in the middle of modifying his or her files.
.PP
The System Administrator or another member of the Lab Staff will be
responsible for bringing the system down to single-user: The operator
should not worry about that.
Once the system is in single-user mode,
.I beer
can be run to do the backups.
.PP
We present a sample
.I beer
session, explaining the options available at each point, and the
reasoning behind them.
Quarterly backups start out the same as usual:
.DS
.CW
% /etc/beer/beer

Please enter type of backup.
Only the first letter is significant.
Case is ignored.

Types of backups are:
	Quarterly
	Monthly
	Weekly
	Daily
Choice (default: d) ?
.CN
.DE
This time however, the answer is \*(lqq\*(rq, for quarterly.
.I Beer
proceeds to prompt with:
.DS
.CW
Current file system is \fIfile system\fP. Skip? (n)
.CN
.DE
.I Beer
is ready to dump the given \fIfile system\fP.
The easiest thing to do is hit RETURN, which will continue with the backup.
Use \*(lqy\*(rq (case does not matter) to skip this file system,
and go on to the next one. This is particularly useful if backups are
taking more than one day, and the file system in question was already
backed up earlier.
An EOF (Control-D) will exit.
.PP
Once you've hit RETURN,
.I beer
will prompt with:
.DS
.CW
Enter device (default: /dev/rmt8):
.CN
.DE
This is the same as for incremental backups. See the discussion above.
This option will be most useful to use the non-rewinding tape drive
on small file systems; it may be possible to put up to four small
file systems on a single 2400 foot tape.
Should a new device be chosen,
.I beer
will also prompt for a different block size, as described above.
.PP
At the discretion of the System Administrator, the skipping of
file systems and the use of alternate devices can be used together,
by having
.I beer
running on more than one terminal.
Then, one session can be doing one group of file systems on the
local tape drive, while another session can be doing a different group
on a remote drive.
Doing multiple backups should speed up the process somewhat.
These two options allow this possibility, without having to change
the
.I beer
shell source code.
(The System Administrator can arrange to create a terminal session
on a terminal besides the system console when the system is in single-user
mode.)
.PP
Next,
.I beer
prompts with:
.DS
.CW
Send output to the line printer? (y)
.CN
.DE
A reply starting with an upper- or lower-case \*(lqn\*(rq will
tell
.I beer
to have
.I bru
do the backup silently. Any other non-empty response (\*(lqyes,\*(rq
\*(lqdrop dead,\*(rq etc.) will cause
.I beer
to go ahead and print the
.I bru
output.
Hitting RETURN will also send the
.I bru
output to the printer.
Typing an EOF (Control-D) will  exit.
.PP
It may be necessary to not print the
.I bru
output, since the printer tends to jam on long printouts.
(What may happen is that the printout for the first file system jams
the printer, so on subsequent file systems, printouts should not be done.)
.PP
Finally,
.I beer
gets down to work with:
.DS
.CW
Put the first tape for \fIfile system\fP on the drive.
Mount additional tapes when prompted by bru.
hit return when ready (EOF to exit):
.CN
.DE
.I "File system"
will be the name of the particular file system being backed up,
for instance,
.B /u/staff .
Put the first tape on the drive, thread it, load it, and then put the
drive on-line.
Then hit RETURN to proceed with the backup.
As
.I bru
needs additional tapes, it will request them:
mount them in turn.
.PP
Each tape should have two labels.
The first label should look like:
.DS
Quarterly Dump - \fIQuarter Year\fP
\fIFile system\fP - Tape \fIN\fP of \fIM\fP
.DE
where
.I quarter
is the quarter just ending (e.g. Summer), and 
.I year
is the year.
.I "File system"
is the name of the file system just dumped.
The label will also indicate that the tape is
.I N
of
.I M ,
for instance, 2 of 4.
(Usually the tapes are labeled \*(lq2 of\*(rq, with the \*(lq4\*(rq
being filled in after the entire file system is done, and the total
number of tapes are known.)
.PP
The second tape label is the same for all the tapes:
.DS
Vax 11/780 - BRL Unix 3.0 (4.2 BSD)
BRU Format
20K Blocks
.DE
which describes the machine, operating system, and block size used to
create the tape.
If a different device was used, with a different block size,
note the block size on the label instead of the \*(lq20K\*(rq.
.PP
Finally, one of the thin edge labels should be placed on the tape ring,
and the quarter, year, file system, and tape number written on the tape,
so that once the tape is placed in a tape rack, it is clear what the
contents of the tape are (for instance, \*(lqSummer 85 - /usr - 2\*(rq).
.NH
FURTHER INFORMATION
.PP
More information about 
.I beer
can be found in the
.I beer (8)
manual page, the file
.B /etc/beer/tapesets ,
and, of course,
the C and shell source code.
