#ifndef lint
static char *RCSid = "$Header: /ecn1/src/ecn/backup/RCS/tape.c,v 1.5 87/09/18 07:58:09 davy Exp $";
#endif

/*
 * tape.c - routines for working with the tape drive
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	tape.c,v $
 * Revision 1.5  87/09/18  07:58:09  davy
 * Now prints level of tape when asking for partial/full tape.
 * 
 * Revision 1.4  87/03/23  15:13:15  davy
 * Changed to work on remote tape drives.
 * 
 * Revision 1.3  87/03/20  13:08:39  davy
 * Modified to run under Sun/OS 3.0.
 * 
 * Revision 1.2  86/08/16  10:38:25  davy
 * Fixed a bug when remotedump is on... had to mark tape as being unmounted.
 * 
 * Revision 1.1  86/08/16  10:37:49  davy
 * Initial revision
 * 
 */
#ifdef sun
#include <sys/param.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <sys/ioctl.h>
#include <ufs/inode.h>
#include <sys/mtio.h>
#include <sys/file.h>
#include <dumprestor.h>
#include <stdio.h>
#else
#include <sys/param.h>
#include <sys/inode.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <sys/file.h>
#include <protocols/dumprestore.h>
#include <stdio.h>
#endif

#include "backup.h"
#include "externs.h"

extern char *days[];			/* in tapemark.c */

/*
 * get_new_tape - prompt operator to mount the next tape
 */
get_new_tape(b)
struct backup *b;
{
	char t1[16], t2[16], t3[16];
	register int density, tenthsperirg;

	/*
	 * Rewind and offline the currently mounted tape.
	 */
	if (Tapemounted == GO) {
		tape_rewind();
		tape_offline();
	}

	Tapereel++;
	Tapefile = Firstdumprec;
	Tapeleft = atoi(Tapelength);

	/*
	 * Calculate blocks available on tape as total number of
	 * blocks that fit minus the length of all the inter-record
	 * gaps.
	 */
	density = atoi(Density);
	tenthsperirg = density == 6250 ? 3 : 7;
	Blocksleft = (Tapeleft * 12 * density) / TP_BSIZE;
	Blocksleft -= (((Blocksleft * tenthsperirg) / 10) * density) / (atoi(Blocksize) * TP_BSIZE);

	/*
	 * Ask for the tape.
	 */
	if (b->d_levels[Weekday] == FULLDUMPLEVEL)
		message("mount level %c full-dump reel #%d for host %s.\n", b->d_levels[Weekday], Tapereel, Hostname);
	else
		message("mount level %c partial-dump reel #%d for host %s for %s.\n", b->d_levels[Weekday], Tapereel, Hostname, days[Weekday]);

	/*
	 * See if it's mounted.
	 */
	while (query("is the correct tape mounted and ready to go?", 0) == STOP)
		abort_backup();

	Tapemounted = GO;

	(void) sprintf(t1, "%d", Tapereel);
	(void) sprintf(t2, "%s", b->d_levels[Weekday] == FULLDUMPLEVEL ? "full" : "partial");
	(void) sprintf(t3, "%c", b->d_levels[Weekday]);

	if (ison(Verify)) {
		message("verifying tape label.\n", 0);

		/*
		 * Verify the tape by looking at the tape label.
		 */
		while (tapemark(0, "dump", Hostname, t1, t2, t3, Rewtape) == STOP) {
			message("correct the problem, and then come back.\n", 0);

			while (query("is the correct tape mounted and ready to go?", 0) == STOP)
				abort_backup();
		}

		message("correct tape is mounted.\n", 0);
	}

	if (ison(Label)) {
		message("writing new tape label.\n", 0);

		/*
		 * Put out a new tape label.
		 */
		while (tapemark(1, "dump", Hostname, t1, t2, t3, Norewtape) == STOP) {
			while (query("shall I try writing the tape label again?", 0) == STOP)
				abort_backup();
		}
	}
}

/*
 * tape_rewind - rewind the currently mounted tape.
 */
tape_rewind()
{
	register int tf;
	struct mtop mtop;

	if (Tapemounted == STOP)
		return;

	if ((tf = mtopen(Rewtape, O_RDONLY)) < 0)
		return;

	message("rewinding reel #%d.\n", Tapereel, 0);

	mtop.mt_op = MTREW;
	mtop.mt_count = 1;

	if (mtioctl(tf, MTIOCTOP, &mtop) < 0)
		message("WARNING: attempt to rewind tape drive failed.\n", 0);

	(void) mtclose(tf);
}

/*
 * tape_offline - take the tape drive off line.
 */
tape_offline()
{
	register int tf;
	struct mtop mtop;

	if (Tapemounted == STOP)
		return;

	if ((tf = mtopen(Rewtape, O_RDONLY)) < 0)
		return;

	message("taking tape drive off line.\n", 0);

	mtop.mt_op = MTOFFL;
	mtop.mt_count = 1;

	if (mtioctl(tf, MTIOCTOP, &mtop) < 0)
		message("WARNING: attempt to offline tape drive failed.\n", 0);

	Tapemounted = STOP;

	(void) mtclose(tf);
}
