#ifndef lint
static char *RCSid = "$Header: /ecn1/src.new/ecn/backup/RCS/interact.c,v 1.3 86/02/03 07:18:08 davy Exp $";
#endif

/*
 * interact.c - routines for interacting with the user
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	interact.c,v $
 * Revision 1.3  86/02/03  07:18:08  davy
 * Added console() routine to log messages on console even if we aren't
 * running on console.  Modified fatal() to log all fatal errors via
 * this routine, also backup.c modified to log start and end of dumps.
 * 
 * Revision 1.2  86/01/07  09:11:29  davy
 * Added a newline where one was missing.
 * 
 * Revision 1.1  86/01/07  09:10:55  davy
 * Initial revision
 * 
 */
#include <sys/ioctl.h>
#include <signal.h>
#include <ctype.h>
#include <stdio.h>

#include "backup.h"
#include "externs.h"

static char *leader = MESSAGELEADER;

/*
 * message - print a message.
 */
/*VARARGS*/
/*ARGSUSED*/
message(fmt, arg1, arg2, arg3, arg4, arg5)
char *fmt, *arg1, *arg2, *arg3, *arg4, *arg5;
{
	(void) printf("%s ", leader);
	(void) printf(fmt, arg1, arg2, arg3, arg4, arg5);
	(void) fflush(stdout);
}

/*
 * fatal - print a message and die.
 */
/*VARARGS*/
/*ARGSUSED*/
fatal(fmt, arg1, arg2, arg3, arg4, arg5)
char *fmt, *arg1, *arg2, *arg3, *arg4, *arg5;
{
	(void) printf("%s FATAL ERROR: ", leader);
	(void) printf(fmt, arg1, arg2, arg3, arg4, arg5);
	(void) fflush(stdout);

	if (Processid != -1)
		(void) killpg(Processid, SIGKILL);

	if (Tapemounted == GO) {
		tape_rewind();
		tape_offline();
	}

	console(fmt, arg1, arg2, arg3, arg4, arg5);
	exit(1);
}

/*
 * console - log a message on the console, provided we aren't already
 *	     writing to the console.
 */
/*VARARGS*/
/*ARGSUSED*/
console(fmt, arg1, arg2, arg3, arg4, arg5)
char *fmt, *arg1, *arg2, *arg3, *arg4, *arg5;
{
	FILE *fp;
	char *tty;
	long clock;
	char *ctime(), *ttyname();

	if ((tty = ttyname(1)) != NULL) {
		if (!strcmp(tty, "/dev/console"))
			return;
	}

	if ((fp = fopen("/dev/console", "w")) == NULL)
		return;

	(void) time(&clock);

	(void) fprintf(fp, "\n%s [%.12s] ", leader, ctime(&clock)+4);
	(void) fprintf(fp, fmt, arg1, arg2, arg3, arg4, arg5);
	(void) fclose(fp);
}

/*
 * query - ask the user a question.
 */
/*VARARGS*/
/*ARGSUSED*/
query(fmt, arg1, arg2, arg3, arg4, arg5)
char *fmt, *arg1, *arg2, *arg3, *arg4, *arg5;
{
	char answer[64];
	register char *s;

	for (;;) {
		(void) printf("\007\007\007");
		(void) printf("%s ", leader);
		(void) printf(fmt, arg1, arg2, arg3, arg4, arg5);
		(void) printf(" (go/stop): ");

		if (gets(answer) == NULL)
			fatal("cannot read from console.\n", 0);

		for (s = answer; *s; s++) {
			if (isupper(*s))
				*s = tolower(*s);
		}

		if (!strcmp(answer, "go"))
			return(GO);

		if (!strcmp(answer, "stop"))
			return(STOP);

		message("\007answer only \"go\" or \"stop\".\n", 0);
	}
}

/*
 * abort_backup - ask if he wants to abort.
 */
abort_backup()
{
	message("do you really want to abort the backup procedure?\n", 0);

	if (query("type \"go\" to continue, \"stop\" to abort.", 0) == GO)
		return;

	message("backup procedure aborted.\n", 0);
	console("backup procedure aborted.\n", 0);

	if (Processid != -1)
		(void) killpg(Processid, SIGKILL);

	if (Tapemounted == GO) {
		tape_rewind();
		tape_offline();
	}

	if (logfp != NULL)
		fprintf(logfp, "\n\t================ DUMP ABORTED BY OPERATOR ================\n");

	exit(1);
}

#ifdef DEBUG
/*VARARGS*/
/*ARGSUSED*/
debug(fmt, arg1, arg2, arg3, arg4, arg5)
char *fmt, *arg1, *arg2, *arg3, *arg4, *arg5;
{
	(void) printf("   DEBUG: ");
	(void) printf(fmt, arg1, arg2, arg3, arg4, arg5);
	(void) fflush(stdout);
}
#endif
