#ifndef lint
static char *RCSid = "$Header: /ecn1/src/ecn/backup/RCS/tapemark.c,v 1.5 88/04/21 13:41:07 davy Exp $";
#endif

/*
 * tapemark - read/write marks on dump tapes
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	tapemark.c,v $
 * Revision 1.5  88/04/21  13:41:07  davy
 * Added more machine types.
 * 
 * Revision 1.4  87/03/23  15:14:15  davy
 * Changed to work on remote tape drives.
 * 
 * Revision 1.3  87/03/23  08:51:39  davy
 * Added machine definition for Sun-3.
 * 
 * Revision 1.2  86/02/28  15:38:54  davy
 * Added CCI machine.
 * 
 * Revision 1.1  86/02/28  15:38:18  davy
 * Initial revision
 * 
 */
#include <sys/types.h>
#include <sys/time.h>
#include <strings.h>
#include <stdio.h>

#include "backup.h"
#include "externs.h"

#define tl	tl_un.tlabel

/*
 * Pad to a nice size.
 */
union {
	struct tapelabel tlabel;
	char pad[TM_BSIZE];
} tl_un;

/*
 * Set the machine type.
 */
#ifdef vax
static char *machine = "VAX-11/780";
#endif
#ifdef GOULD_PN
static char *machine = "GOULD PN9080";
#endif
#ifdef GOULD_NP
static char *machine = "GOULD NP-1";
#endif
#ifdef pdp11
static char *machine = "PDP-11/70";
#endif
#ifdef tahoe
static char *machine = "CCI 6/32";
#endif
#if sun && mc68020
static char *machine = "SUN-3";
#endif
#if sun && sparc
static char *machine = "SUN-4";
#endif

static short cflag;
static short wflag;

static char *host;
static char *reel;
static char *type;
static char *level;
static char *format;
static char *tapedev;

char *days[] = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
		 "Friday", "Saturday", 0 };

/*
 * tapemark - write or check a tape mark.
 */
tapemark(mode, f, h, r, t, l, d)
int mode;
char *f, *h, *r, *t, *l, *d;
{
	register int tf;

	host = h;
	reel = r;
	type = t;
	level = l;
	format = f;
	tapedev = d;
	
	if (mode) {
		cflag = 0;
		wflag = 1;
	}
	else {
		cflag = 1;
		wflag = 0;
	}

	/*
	 * Open the tapedrive for reading and/or writing.
	 */
	if ((tf = mtopen(tapedev, wflag)) < 0) {
		if (wflag)
			message("tape drive not on line or no write ring.\n", 0);
		else
			message("tape drive not on line.\n", 0);

		return(STOP);
	}

	/*
	 * Check or write the record.
	 */
	if (cflag)
		return(checkmark(tf));
	else
		return(writemark(tf));
}

/*
 * writemark - write a new record on the tape.
 */
writemark(tf)
register int tf;
{
	struct timeval tv;

	(void) gettimeofday(&tv, (struct timezone *) 0);

	tl.tl_reel = atoi(reel);
	tl.tl_level = atoi(level);

	(void) strcpy(tl.tl_host, host);
	(void) strcpy(tl.tl_format, format);
	(void) strcpy(tl.tl_machine, machine);
	(void) sprintf(tl.tl_time, "%ld", tv.tv_sec);

	if (!strcmp(type, "full"))
		tl.tl_type = TM_FULLDUMP;
	else
		tl.tl_type = TM_PARTIALDUMP;

	if (mtwrite(tf, &tl, TM_BSIZE) != TM_BSIZE) {
		message("cannot write tape label to tape drive.\n", 0);

		(void) mtclose(tf);
		return(STOP);
	}

	(void) mtclose(tf);
	return(GO);
}

/*
 * checkmark - read a record from the tape and check it.  If anything
 *	       is amiss, ask the user if he knows what he's doing.
 */
checkmark(tf)
register int tf;
{
	long atol();
	struct tm *localtime();
	struct tm nowtm, dumptm;
	struct timeval nowtv, dumptv;

	if (mtread(tf, &tl, TM_BSIZE) != TM_BSIZE) {
		message("cannot read tape label from tape drive.\n", 0);

		(void) mtclose(tf);
		return(STOP);
	}

	(void) mtclose(tf);

	if (!strcmp(type, "full") && (tl.tl_type != TM_FULLDUMP)) {
		message("the tape you have mounted is not a full-dump tape.\n", 0);

		if (doquery() == STOP)
			return(STOP);
	}
	else if (!strcmp(type, "partial") && (tl.tl_type != TM_PARTIALDUMP)) {
		message("the tape you have mounted is not a partial-dump tape.\n", 0);

		if (doquery() == STOP)
			return(STOP);
	}

	if ((char) atoi(level) != tl.tl_level) {
		message("the tape you have mounted is a level %d tape,\n", tl.tl_level, 0);
		message("but it should be a level %d tape.\n", atoi(level), 0);

		if (doquery() == STOP)
			return(STOP);
	}

	if ((char) atoi(reel) != tl.tl_reel) {
		message("the tape you have mounted is reel number %d,\n", tl.tl_reel, 0);
		message("but it should be reel number %d.\n", atoi(reel), 0);

		if (doquery() == STOP)
			return(STOP);
	}

	if (strcmp(host, tl.tl_host) != 0) {
		message("the tape you have mounted is for host %s,\n", tl.tl_host, 0);
		message("it should be for host %s.\n", host, 0);

		if (doquery() == STOP)
			return(STOP);
	}

	if (strcmp(format, tl.tl_format) != 0) {
		message("the tape you have mounted is in %s format,\n", tl.tl_format, 0);
		message("it should be in %s format.\n", format, 0);

		if (doquery() == STOP)
			return(STOP);
	}

	dumptv.tv_sec = atol(tl.tl_time);
	(void) gettimeofday(&nowtv, (struct timezone *) 0);

	if (tl.tl_type == TM_FULLDUMP) {
		if ((nowtv.tv_sec - dumptv.tv_sec) < TM_NEWTHRESH) {
			message("the full-dump tape you have mounted is less than %d days old.\n", TM_NEWTHRESH / TM_DAY, 0);

			if (doquery() == STOP)
				return(STOP);
		}

		if ((nowtv.tv_sec - dumptv.tv_sec) > TM_OLDTHRESH) {
			message("the full-dump tape you have mounted is more than %d days old.\n", TM_OLDTHRESH / TM_DAY, 0);

			if (doquery() == STOP)
				return(STOP);
		}
	}
	else {
		nowtm = *localtime(&nowtv.tv_sec);
		dumptm = *localtime(&dumptv.tv_sec);

		if (nowtm.tm_wday != dumptm.tm_wday) {
			message("the partial-dump tape you have mounted is for %s,\n", days[dumptm.tm_wday], 0);
			message("but today is %s.\n", days[nowtm.tm_wday], 0);

			if (doquery() == STOP)
				return(STOP);
		}
	}

	return(GO);
}

/*
 * doquery - see if the user knows what he's doing.
 */
doquery()
{
	return(query("do you really want to write on this tape?", 0));
}

