#ifndef lint
static char *RCSid = "$Header: /ecn1/src/ecn/backup/RCS/pty.c,v 1.4 88/04/11 08:14:22 davy Exp $";
#endif

/*
 * pty.c - handle getting a pseudo-tty to run dump.
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	pty.c,v $
 * Revision 1.4  88/04/11  08:14:22  davy
 * Added more ptys.
 * 
 * Revision 1.3  87/03/23  15:11:44  davy
 * Fixed the process group code to do things in the right order.  This
 * fixes things under SunOS 3.0's TIOCSPGRP checks.
 * 
 * Revision 1.2  86/01/04  02:54:12  root
 * Moved setpriority() call from backup.c to here, so that only the
 * dump commands run at super-good priority.
 * 
 * Revision 1.1  86/01/04  02:47:21  root
 * Initial revision
 * 
 */
#include <sys/param.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <signal.h>
#include <stdio.h>

#include "backup.h"
#include "externs.h"

/*
 * ptyopen - open a pseudo-tty and exec a process on it.
 */
ptyopen(cmd, ifp, ofp)
char *cmd;
FILE **ifp, **ofp;
{
	int i;
	char *args[16];
	register int tty;
	long ldisc, lmode;
	register char *s, *t;
	struct sgttyb sgttyb;
	struct tchars tchars;
	struct ltchars ltchars;
	char ttybuf[16], ptybuf[16];

	/*
	 * Split up the arguments.
	 */
	i = 0;
	s = cmd;

	while (*s) {
		while ((*s == ' ') || (*s == '\t'))
			*s++ = NULL;

		args[i++] = s;

		while ((*s != NULL) && (*s != ' ') && (*s != '\t'))
			s++;
	}

	args[i] = NULL;

	/*
	 * Get a pseudo-tty.
	 */
#ifdef gould
	/*
	 * This is GROSS, but it's what Gould does since they don't even
	 * ship harwired serial ports any more.
	 */
	for (s = "pqrstuvwxyzklmno"; *s != NULL; s++) {
#else
	for (s = "pqrstuvw"; *s != NULL; s++) {
#endif
		for (t = "0123456789abcdef"; *t != NULL; t++) {
			(void) sprintf(ptybuf, "/dev/pty%c%c", *s, *t);

			if ((tty = open(ptybuf, O_RDWR)) >= 0)
				goto out;
		}
	}

out:
	if ((*s == NULL) && (*t == NULL))
		fatal("can't find a pty to run dump.\n", 0);

	(void) strcpy(ttybuf, ptybuf);
	ttybuf[5] = 't';

#ifdef DEBUG
	debug("MASTER: %s   SLAVE: %s\n", ptybuf, ttybuf, 0);
#endif

	/*
	 * Get our terminal modes.
	 */
	(void) ioctl(0, TIOCGETD, &ldisc);
	(void) ioctl(0, TIOCLGET, &lmode);
	(void) ioctl(0, TIOCGETP, &sgttyb);
	(void) ioctl(0, TIOCGETC, &tchars);
	(void) ioctl(0, TIOCGLTC, &ltchars);

	while ((Processid = fork()) < 0) {
		message("cannot fork -- retrying...\n", 0);
		sleep(5);
	}

	/*
	 * In the child...
	 */
	if (Processid == 0) {
		/*
		 * Clear file descriptors.
		 */
		for (i=0; i < NOFILE; i++)
			(void) close(i);

		/*
		 * Clear controlling tty.
		 */
		if ((i = open("/dev/tty", O_RDWR)) >= 0) {
			(void) ioctl(i, TIOCNOTTY, 0);
			(void) close(i);
		}

		/*
		 * Make stdin, stdout, stderr.  This also
		 * makes our controlling tty the pty.
		 */
		i = open(ttybuf, O_RDWR);

		(void) dup2(i, 0);
		(void) dup2(i, 1);
		(void) dup2(i, 2);

		/*
		 * Set tty modes.
		 */
		sgttyb.sg_flags &= ~ECHO;
		sgttyb.sg_flags &= ~CRMOD;

		(void) ioctl(0, TIOCSETD, &ldisc);
		(void) ioctl(0, TIOCLGET, &lmode);
		(void) ioctl(0, TIOCSETP, &sgttyb);
		(void) ioctl(0, TIOCSETC, &tchars);
		(void) ioctl(0, TIOCSLTC, &ltchars);

		/*
		 * Set up process group.
		 */
		(void) ioctl(0, TIOCGPGRP, &i);
		(void) setpgrp(0, i);

		i = getpid();

		(void) ioctl(0, TIOCSPGRP, &i);
		(void) setpgrp(0, i);

#ifndef DEBUG
		/*
		 * Kick our priority.
		 */
		(void) setpriority(PRIO_PROCESS, getpid(), DUMPPRIORITY);
#endif

		(void) execv(*args, args);

		fatal("cannot execute %s\n", Dumpcommand, 0);
		exit(1);
	}

	*ifp = fdopen(tty, "w");
	*ofp = fdopen(tty, "r");
}
