#ifndef lint
static char *RCSid = "$Header: /usr/harbor/davy/system/backup/RCS/estimate.c,v 1.2 87/03/20 13:08:26 davy Exp $";
#endif

/*
 * estimate.c - estimate number of blocks to be dumped from this disk
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	estimate.c,v $
 * Revision 1.2  87/03/20  13:08:26  davy
 * Modified to run under Sun/OS 3.0.
 * 
 * Revision 1.1  87/03/20  11:18:55  davy
 * Initial revision
 * 
 */
#ifdef sun
#include <sys/param.h>
#include <sys/time.h>
#include <sys/vnode.h>
#include <ufs/inode.h>
#include <sys/file.h>
#include <ufs/fs.h>
#include <dumprestor.h>
#include <stdio.h>
#else
#include <sys/param.h>
#include <sys/inode.h>
#include <sys/file.h>
#include <sys/fs.h>
#include <protocols/dumprestore.h>
#include <stdio.h>
#endif

#include "backup.h"
#include "externs.h"

#define ISIZ	(MAXBSIZE / sizeof(struct dinode))
#define sblock	sb_un.u_sblock

static union {
	struct fs u_sblock;
	char dummy[SBSIZE];
} sb_un;

static struct dinode itab[ISIZ];

/*
 * estimate - romp through the inodes on a raw disk device and find
 *	      all the blocks we need to dump.  This routine will
 *	      over-estimate most of the time (as opposed to dump's
 *	      under-estimating).  This code more or less stolen from
 *	      quot.c.
 */
estimate(b, esize, fetapes)
struct backup *b;
long *esize;
float *fetapes;
{
	int f, fd;
	daddr_t iblk;
	size_t blocks;
	register int i, nfiles;
	register unsigned int ino;

	if ((fd = open(b->d_device, O_RDONLY)) < 0)
		fatal("cannot open \"%s\" for reading.", b->d_device, 0);

	/*
	 * Put everything on disk.
	 */
	(void) sync();

	/*
	 * Grab the super block.
	 */
	bread(fd, SBLOCK, &sblock, SBSIZE);

	/*
	 * Number of files is number of inodes per cylinder
	 * group times number of cylinder groups.
	 */
	blocks = 0;
	nfiles = sblock.fs_ipg * sblock.fs_ncg;

	/*
	 * For each inode...
	 */
	for (ino = 0; ino < nfiles; ) {
		/*
		 * Read in the inode table for this cylinder group.
		 */
		iblk = fsbtodb(&sblock, itod(&sblock, ino));
		bread(fd, iblk, itab, sblock.fs_bsize);

		/*
		 * For each inode...
		 */
		for (i=0; (i < INOPB(&sblock)) && (ino < nfiles); i++, ino++) {
			if (ino < ROOTINO)
				continue;

			/*
			 * Unallocated.
			 */
			if ((f = (itab[i].di_mode & IFMT)) == 0)
				continue;

			/*
			 * If the inode change time or file mod time
			 * are greater than the time we're dumping
			 * from, or if this is a directory, count
			 * this file.  Dump doesn't actually count
			 * all the directories, but this is simpler.
			 */
			if ((itab[i].di_ctime >= b->d_lastdump) || (itab[i].di_mtime >= b->d_lastdump) ||
			    ((itab[i].di_mode & IFMT) == IFDIR)) {
			    	if ((f != IFREG) && (f != IFDIR) && (f != IFLNK))
					blocks += howmany(TP_BSIZE, DEV_BSIZE);

				blocks += itab[i].di_blocks + 1;

				/*
				 * Indirect tape blocks (convert to
				 * file system blocks).
				 */
			    	if (itab[i].di_size > (sblock.fs_bsize * NDADDR)) {
					blocks += howmany(TP_BSIZE, DEV_BSIZE) * 
						  howmany(howmany(itab[i].di_size, TP_BSIZE) - (NDADDR * sblock.fs_bsize / TP_BSIZE), TP_NINDIR);
				}
			}
		}
	}

	(void) close(fd);

	/*
	 * Estimate number of blocks and number of tapes.
	 */
	est(blocks, nfiles, esize, fetapes);

	/*
	 * For some reason, on level zero dumps, we come
	 * up about 10% low.  I don't understand why, I've
	 * looked at it for 4 hours now.  Just bag it and
	 * fudge, since the estimate doesn't have to be
	 * exact anyway.
	 */
	if (b->d_levels[Weekday] == FULLDUMPLEVEL) {
		*esize += *esize / 10;
		*fetapes = *fetapes * 1.10;
	}
}

/*
 * est - estimate number of tape blocks and number of tapes needed
 *	 for the dump.  This code pretty much stolen from dumpitime.c.
 */
est(blocks, nfiles, esize, fetapes)
size_t blocks;
long nfiles;
long *esize;
float *fetapes;
{
	int msiz, etapes, tenthsperirg;

	/*
	 * Convert blocks to tape blocks, calculate the
	 * number of tenths of an inch an inter-record
	 * gap takes, the size of one of dump's maps.
	 */
	tenthsperirg = (atoi(Density) == 6250 ? 3 : 7);
	msiz = roundup(howmany(nfiles, NBBY), TP_BSIZE);
	*esize = howmany((blocks * DEV_BSIZE), TP_BSIZE);

	*esize += 2 * (howmany(msiz, TP_BSIZE) + 1);

	/*
	 * Calculate number of tapes.  You figure it out.
	 */
	*fetapes = (	*esize *			/* tape blocks	*/
			TP_BSIZE *			/* bytes/block	*/
			(1.0 / (atoi(Density) / 10)) +	/* 0.1" / byte	*/
			*esize *			/* tape blocks	*/
			(1.0 / atoi(Blocksize)) *	/* IRG's/block	*/
			tenthsperirg			/* 0.1"/IRG	*/
		    ) *
		    (1.0 / (atoi(Tapelength) * 120));	/* tape/0.1"	*/

	etapes = *fetapes + 1;				/* round up	*/
	*esize += etapes + 10;				/* trailer blks	*/
	*esize += etapes * (howmany(msiz, TP_BSIZE) + 1);	/* maps */
}

/*
 * bread - read in the bno'th block on the device.
 */
bread(fd, bno, buf, cnt)
int fd, cnt;
unsigned bno;
char *buf;
{
	(void) lseek(fd, (long) bno * DEV_BSIZE, L_SET);

	if (read(fd, buf, cnt) != cnt)
		fatal("read error on raw disk.", 0);
}

