/*
 * $Header: /usr/harbor/davy/system/backup/RCS/backup.h,v 1.5 87/03/23 15:09:06 davy Exp $
 *
 * backup.h - global definitions for backup program
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	backup.h,v $
 * Revision 1.5  87/03/23  15:09:06  davy
 * Kicked up a couple of character array sizes.
 * 
 * Revision 1.4  87/03/23  08:48:57  davy
 * Increased the size of a couple of constants.
 * 
 * Revision 1.3  86/01/04  04:37:50  root
 * Put DUMPPRIORITY back to -20 since previously mentioned problem is
 * now fixed.
 * 
 * Added separate BACKUPPRIORITY which does to backup what DUMPPRIORITY
 * does to dump (and used to do to backup).
 * 
 * Revision 1.2  86/01/04  04:14:21  root
 * Changed DUMPPRIORITY to 0 since it always worked that way in testing.
 * For some weird reason things don't work at better priorities.  Dump
 * is smart enough to deal with this though.
 * 
 * Revision 1.1  86/01/04  04:13:52  root
 * Initial revision
 * 
 */

/*
 * Miscellaneous constants.
 */
#define GO		1
#define STOP		0
#define RMTPROG		"/etc/rmt"
#define DEVSIZE		64
#define VARSIZE		64
#define DATESIZE	32
#define INFOFILE	"/etc/backup.tapes"
#define DUMPFLAGS	"fdsb"
#define DUMPDATES	"/etc/dumpdates"
#define COMMENTCHAR	'#'
#define DUMPDATESFMT	"%s %c %[^\n]%c"
#define DUMPPRIORITY	-20
#define FULLDUMPLEVEL	'0'
#define SKIPDUMPLEVEL	'-'
#define MESSAGELEADER	"  BACKUP:"
#define DUMPUPDATEFLAG	'u'
#define BACKUPPRIORITY	-19

/*
 * Types of backup structures.
 */
#define B_DUMPCMD	1
#define B_NEWTAPE	2
#define B_VARIABLE	3

/*
 * Constants for the tapemark routine.
 */
#define TM_DAY		(24 * 60 * 60)
#define TM_BSIZE	128
#define TM_FULLDUMP	'F'
#define TM_NEWTHRESH	(25 * TM_DAY)
#define TM_OLDTHRESH	(60 * TM_DAY)
#define TM_PARTIALDUMP	'P'

/*
 * Shorthand.
 */
#define v_name		b_cl.v.vv_name
#define v_value		b_cl.v.vv_value
#define d_sreel		b_cl.d.dd_sreel
#define d_weeks		b_cl.d.dd_weeks
#define d_levels	b_cl.d.dd_levels
#define d_device	b_cl.d.dd_device
#define d_needed	b_cl.d.dd_needed
#define d_lastdump	b_cl.d.dd_lastdump
#define n_newreelnums	b_cl.newreelnums

#define ison(x)		(strcmp((x), "on") == 0)

/*
 * A tape label.
 */
struct tapelabel {
	char tl_type;
	char tl_reel;
	char tl_level;
	char tl_host[32];
	char tl_time[16];
	char tl_format[8];
	char tl_machine[16];
};

/*
 * A variable.
 */
struct variable {
	char	vv_name[VARSIZE];		/* variable name	*/
	char	vv_value[VARSIZE];		/* variable value	*/
};

/*
 * A dump command.
 */
struct dumpcmd {
	short	dd_sreel;			/* start tape reel no.	*/
	short	dd_needed;			/* 1 if needs dumping	*/
	long	dd_lastdump;			/* time of last dump	*/
	char	dd_weeks[16];			/* weeks field		*/
	char	dd_levels[16];			/* levels field		*/
	char	dd_device[DEVSIZE];		/* device name		*/
};

/*
 * Backup structure.  One of these for each "meaningful" line
 * in the control file.
 */
struct backup {
	union {
		struct dumpcmd d;
		struct variable v;
		char newreelnums[8];
	} b_cl;

	short	b_type;				/* type of line		*/
	short	b_lineno;			/* line number		*/
	struct backup	*b_next;		/* pointer to next one	*/
};
