#ifndef lint
static char *RCSid = "$Header: /ecn1/src/ecn/backup/RCS/mt.c,v 1.3 87/06/30 14:18:40 jrs Exp $";
#endif

/*
 * mt - routines to handle tape drives
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * March, 1987
 *
 */
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/ioctl.h>
#include <sys/mtio.h>
#include <strings.h>
#include <signal.h>
#include <netdb.h>
#include <stdio.h>
#include <pwd.h>

#include "backup.h"
#include "externs.h"

#define TS_OPEN		1
#define TS_CLOSED	0

int rmtconnaborted();

static int rmtfd = -1;			/* network file descriptor	*/
static char rmtpeer[VARSIZE];		/* host we're going to		*/
static char rmttape[VARSIZE];		/* tape drive we have open	*/
static int rmtstate = TS_CLOSED;	/* state of tape drive		*/

/*
 * rmthost - get a connection to the remote host.
 */
char *rmthost(tape)
register char *tape;
{
	char *s;
	struct passwd *pw;
	struct servent *sp;
	char *name = "root";
	char *index(), *rindex();

	/*
	 * Get hostname.
	 */
	strcpy(rmtpeer, tape);

	if ((s = index(rmtpeer, ':')) == NULL)
		fatal("illegal remote tape specification: \"%s\".\n", tape, 0);

	/*
	 * Get tapedrive name.
	 */
	*s++ = NULL;
	strcpy(rmttape, s);

	/*
	 * Get remote user name.
	 */
	if ((s = rindex(rmtpeer, '.')) != NULL) {
		*s++ = NULL;
		name = s;
	}

	/*
	 * Write errors go to abort.
	 */
	signal(SIGPIPE, rmtconnaborted);

	/*
	 * Look up the server.
	 */
	if ((sp = getservbyname("shell", "tcp")) == NULL)
		fatal("shell/tcp: unknown service.\n", 0);

#ifdef notdef
	/*
	 * Who are we?
	 */
	pw = getpwuid(getuid());

	if ((pw != NULL) && (pw->pw_name != NULL))
		name = pw->pw_name;
#endif

	/*
	 * Connect to the remote host.
	 */
	s = rmtpeer;
	rmtfd = rcmd(&s, sp->s_port, name, name, RMTPROG, 0);

	if (rmtfd < 0)
		fatal("cannot start remote tape program on \"%s\".\n", rmtpeer, 0);

	return(rmttape);
}

/*
 * mtopen - open the magtape device.
 */
mtopen(tape, mode)
register char *tape;
register int mode;
{
	char line[256];
	char *index(), *rmthost();

	/*
	 * Just do it if not remote.
	 */
	if (!ison(Remotedump))
		return(open(tape, mode));

	/*
	 * Get the network connection if we haven't, otherwise
	 * just figure out the tape drvie name and save it.
	 */
	if (rmtfd < 0) {
		tape = rmthost(tape);
	}
	else {
		if ((tape = index(tape, ':')) == NULL)
			tape = rmttape;
		else
			strcpy(rmttape, ++tape);
	}

	/*
	 * Open the remote tape drive.
	 */
	rmtstate = TS_OPEN;
	sprintf(line, "O%s\n%d\n", tape, mode);
	return(rmtcall(tape, line));
}

/*
 * mtclose - close the magtape device.
 */
mtclose(fd)
register int fd;
{
	/*
	 * Just do it if not remote.
	 */
	if (!ison(Remotedump))
		return(close(fd));

	if (rmtstate != TS_OPEN)
		return(0);

	/*
	 * Close the remote tape drive.
	 */
	rmtstate = TS_CLOSED;
	return(rmtcall("close", "C\n"));
}

/*
 * mtread - read from the magtape device.
 */
mtread(fd, buf, count)
register int fd, count;
register char *buf;
{
	char line[256];
	extern int errno;
	register int i, n, cc;

	/*
	 * Just do it if not remote.
	 */
	if (!ison(Remotedump))
		return(read(fd, buf, count));

	/*
	 * Read from the remote tape drive.
	 */
	sprintf(line, "R%d\n", count);
	n = rmtcall("read", line);

	if (n < 0) {
		errno = n;
		return(-1);
	}

	for (i=0; i < n; i += cc) {
		cc = read(rmtfd, buf+i, n - i);

		if (cc <= 0)
			rmtconnaborted();
	}

	return(n);
}

/*
 * mtwrite - write to the magtape device.
 */
mtwrite(fd, buf, count)
register int fd, count;
register char *buf;
{
	char line[256];

	/*
	 * Just do it if not remote.
	 */
	if (!ison(Remotedump))
		return(write(fd, buf, count));

	/*
	 * Write to the remote tape drive.
	 */
	sprintf(line, "W%d\n", count);

	write(rmtfd, line, strlen(line));
	write(rmtfd, buf, count);

	return(rmtreply("write"));
}

/*
 * mtioctl - do an ioctl on the magtape device.
 */
mtioctl(fd, cmd, op)
register int fd, cmd;
register struct mtop *op;
{
	char line[256];

	/*
	 * Just do it if not remote.
	 */
	if (!ison(Remotedump))
		return(ioctl(fd, cmd, op));

	if (op->mt_count < 0)
		return(-1);

	/*
	 * Ioctl the remote tape drive.
	 */
	sprintf(line, "I%d\n%d\n", op->mt_op, op->mt_count);
	return(rmtcall("ioctl", line));
}

/*
 * rmtcall - send a command and wait for a response.
 */
rmtcall(cmd, buf)
register char *cmd, *buf;
{
	if (write(rmtfd, buf, strlen(buf)) != strlen(buf))
		rmtconnaborted();

	return(rmtreply(cmd));
}

/*
 * rmtreply - get a reply from the server.
 */
rmtreply(cmd)
register char *cmd;
{
	register int c;
	char code[32], emsg[BUFSIZ];

	/*
	 * Read a string.
	 */
	rmtgets(code, sizeof(code));

	/*
	 * Check for errors.
	 */
	if ((*code == 'E') || (*code == 'F')) {
		rmtgets(emsg, sizeof(emsg));

		message("rmt%s: %s\n", cmd, emsg, 0);

		if (*code == 'F')
			rmtstate = TS_CLOSED;

		return(-1);
	}

	/*
	 * Check for ACKs.
	 */
	if (*code != 'A') {
		message("rmt%s: remote tape protocol botched (code \"%s\").\n", cmd, code, 0);
		rmtconnaborted();
	}

	return(atoi(code + 1));
}

/*
 * remtgets - get a string from the server.
 */
rmtgets(cp, len)
register char *cp;
register int len;
{
	while (len > 1) {
		*cp = rmtgetb();

		if (*cp == '\n') {
			cp[1] = '\0';
			return;
		}

		len--;
		cp++;
	}

	message("remote tape protocol botched (in rmtgets).\n", 0);
	rmtconnaborted();
}

/*
 * rmtgetb - get a byte from the server.
 */
rmtgetb()
{
	char c;

	if (read(rmtfd, &c, 1) != 1)
		rmtconnaborted();

	return(c);
}

/*
 * rmtconnaborted - abort the connection.
 */
rmtconnaborted()
{
	message("FATAL ERROR: lost connection to remote host.\n", 0);
	exit(1);
}
