#ifndef lint
static char *RCSid = "$Header: /usr/harbor/davy/system/backup/RCS/catalog.c,v 1.2 87/03/23 15:07:34 davy Exp $";
#endif

/*
 * catalog.c - catalog a magnetic tape
 *
 * David A. Curry
 * Purdue Engineering Computer Network
 * November, 1985
 *
 * $Log:	catalog.c,v $
 * Revision 1.2  87/03/23  15:07:34  davy
 * Changed to work with remote tape drives.
 * 
 * Revision 1.1  87/03/23  08:51:59  davy
 * Initial revision
 * 
 */
#include <sys/file.h>
#include <stdio.h>

#include "backup.h"
#include "externs.h"

#define BUFSIZE 	51200
#define min(a, b)	((a) < (b) ? (a) : (b))

static int bufsz;			/* buffer size */
static char buf[BUFSIZE];

/*
 * catalog - read in huge blocks off the magtape, and report their size
 *	     and how many there are.
 */
catalog()
{
	int fd, lastsize;
	register int count, size, filenum;

	if ((fd = mtopen(Rewtape, O_RDONLY)) < 0)
		fatal("cannot open %s.\n", Rewtape, 0);

	message("cataloging tape.\n", 0);
	message("  size   count\n", 0);

	count = 0;
	filenum = 1;
	lastsize = -2;		/* hopefully an impossible value */

	if (bufsz == 0)
		bufsz = BUFSIZE;

	for (;;) {
		while (((size = mtread(fd, buf, min(bufsz, BUFSIZE))) > 0) && (size == lastsize))
			count++;

		if (count)
			printf("  %6d\n", count);

		switch(size) {
		case -1:
			message("read error terminates file #%d\n", filenum, 0);
			(void) mtclose(fd);
			return;
		case 0:
			message("   end of file #%d\n", filenum++, 0);

			if (filenum > Tapefile) {
				(void) mtclose(fd);
				return;
			}

			count = 0;
			lastsize = -2;
			break;
		default:
			count = 1;
			lastsize = size;
			message("%6d", size, 0);
		}
	}
}
