: /bin/sh script
# ----------------------------------------------------------------
# UNARCH.NITE: This program consolidates all the files that users
#              have requested to be unarchived, sorts this and
#              calls a second program, (unarch.tape) to perform
#              the actual extraction from tape.
# ----------------------------------------------------------------
# ----------------------------------------------------------------
#       ARCHDEFS: 
#	Initialize standard archive variables:
# ----------------------------------------------------------------

ADMDIR=/usr/adm         # Directory for archive administrative files.

ETCDIR=/etc		# Directory where most system programs reside.

TOOLDIR=/usr/tools	# Directory where most user-executed programs
			# reside.

UNARDIR=/unarchive      # Directory where unarchived files are placed.
                        # Must be rw by the world.

# ----------------------------------------------------------------
#	Standard archive system files:  (These should NOT change.)
# ----------------------------------------------------------------

ARTABLE=$ADMDIR/archtable  # Database of archived files in the format:
                           # volid <sp> archive-date <sp> absolute-archive-path

ARTAPES=$ADMDIR/archive.tapes   # List of scratch tapes for archiving.

UNARFILE=$UNARDIR/,to.do        # List of files requested by users to be
				# unarchived. Must be rw by the # world. 
				# (using commas so first in # ls listing)

UNARRET=$UNARDIR/,done          # List of files that were retrieved from
				# tape by the unarchive process.

LOGFILE=$UNARDIR/login_names    # List of logon ids that will be used in
				# the unarchive process.

export ADMDIR ETCDIR TOOLDIR UNARDIR ARTABLE ARTAPES UNARFILE UNARRET LOGFILE

# ----------------------------------------------------------------
#	Initialize internal program variables:
# ----------------------------------------------------------------

tmp=/tmp/unarch.tmp
vols=/tmp/unarch.volids

# ----------------------------------------------------------------
#	Get a list of files to be unarchived, sorted by volid:
# ----------------------------------------------------------------

cd $UNARDIR
sort -o $tmp $UNARFILE
#lpr $tmp	#%BSD4% 
#lpr $tmp	#%XENIX%
#lp $tmp	#%SYSV%

# ----------------------------------------------------------------
#	Setup for unarch.tape (tape unarchiving process):
# ----------------------------------------------------------------
#	A list of tape volids needed is put in $vols.
#	Each tape volid is used as the name of a file containing
#	a list of the files to be unarchived from that tape.
# ----------------------------------------------------------------

volid=
cd /tmp
while read num ret dte filepath
do
    case $volid in
    $num)
	;;
    *)
	volid=$num
	echo "$volid" >>$vols
	;;
    esac
    echo "$filepath" >>$volid
done <$tmp

# ----------------------------------------------------------------
#	Execute tape-by-tape unarchiving process:
# ----------------------------------------------------------------

$ETCDIR/unarch.tape

# ----------------------------------------------------------------


