/*
 * UNARCH.LOG: This program should receive arguments passed to it from 
 *             unarch.rqst. It updates /unarchive/login_names and
 *     	      /unarchive/,to.do files with information stored in /tmp
 *	      files.
 */
#include <stdio.h>
#include <errno.h>

/* CHANGE THIS IF ARCH TABLE ELSEWHERE !!! */
#define UNARFILE  "/unarchive/,to.do"
#define UNARLOG  "/unarchive/login_names"

/*
 * The following two defines make string comparison less cryptic.
 */
#define strequ(a, b)		(strcmp((a), (b)) == 0)
#define strnequ(a, b, n)	(strncmp((a), (b), (n)) == 0)

/*
 * Mnemonic defines for true and false conditions.
 */
#define TRUE	1
#define FALSE	0

extern char **environ;
extern int errno;

char *Progname;


main (argc,argv)
     int argc;
     char *argv[];
{
    char   *logname,
	   *InLine,
	   *InFile;

    FILE *Infp,
	 *Logfp,
	 *fopen (),
	 *OpenLog ();

    if (!SecureMe ())
	error ("Secure failed!", "");

    Progname = argv[0];

    InFile = InLine = NULL;

    if (argc > 1)
	logname = argv[1];
    else
	error ("No login name", "");
    if (argc > 2)
    {
	if (argc > 3)
	    if (strequ (argv[2], "-f"))
	        InFile = argv[3];
	    else
		error ("Invalid argument '%s'", argv[2]);
	else
	    InLine = argv[2];
    }
    Logfp = OpenLog (UNARFILE, "a");
    if (InFile != NULL)
    {
	if ((Infp = fopen (InFile, "r")) == NULL)
	    error ("Can't open input file '%s'", InFile);
	while (fgets (InLine, sizeof InLine, Infp) != NULL)
	    if (fputs (InLine, Logfp) == NULL)
		error ("Couldn't write log file '%s'", UNARFILE);
    }
    else
    {
	if (InLine != NULL)
	    fprintf (Logfp, "%s\n", InLine);
    }
    CloseLog (UNARFILE, Logfp);

    Logfp = OpenLog (UNARLOG, "a");
    fprintf (Logfp, "%s\n", logname);
    CloseLog (UNARLOG, Logfp);

    exit (0);
}


/*----------------------------------------------------------------------
 *
 * OpenLog -- Open file locked.
 */

FILE *OpenLog (File, mode)
char *File;
char *mode;
{
    register int times;
    char LockFile[256];
    int fd;
    FILE *fp,
	 *fopen();
    
    sprintf (LockFile, "%s.LCK", File);
    if (access (File, 0) == -1)
	if ((fd = creat (File, 0644)) == -1)
	    error ("Can't create %s", File);
	else
	    close (fd);
    for (times = 0; link (File, LockFile) == -1 && times < 10; times++)
    {
	if (errno != EEXIST)
	    error ("Can't create LockFile %s", LockFile);
	sleep (1);
    }
    if (times >= 10)
	error ("Lock file %s left around by another process", LockFile);
    if ((fp = fopen (File, mode)) == NULL)
	error ("Can't open log file %s", File);
    return (fp);
}


/*----------------------------------------------------------------------
 *
 * CloseLog -- Close locked file.
 */

CloseLog (File, fp)
char *File;
FILE *fp;
{
    char LockFile[256];
    
    sprintf (LockFile, "%s.LCK", File);
    fclose (fp);
    unlink (LockFile);
}


#ifdef UCB
#    define SAFE_PATH	"PATH=/bin:/usr/bin:/usr/ucb"
#else
#    ifdef PLX
#        define SAFE_PATH	"PATH=/bin:/usr/bin:/usr/plx"
#    else
#        define SAFE_PATH	"PATH=/bin:/usr/bin"
#    endif
#endif

/*----------------------------------------------------------------------
 *
 * SecureMe--Secure the environment for setuid program.
 */

SecureMe ()
{
    char *p,
	 *getenv ();
    char **ep;

    umask (022);

    if ((p = getenv ("IFS")) != NULL)
	*p = '\0';
    for (ep = environ; *ep; ep++)
	if (strnequ (*ep, "PATH=", 5))
	    *ep = SAFE_PATH;
    return (TRUE);
}
/* End SecureMe () */


/*----------------------------------------------------------------------
 *
 *error -- Print out error message and exit program.
 */

error (format, arg)
char *format;
char *arg;
{
    char ErrStr[256];

    sprintf (ErrStr, "%s:  %s\n", Progname, format);
    printf (ErrStr, arg);
    exit (3);
}
/* End error () */




/* OLD CODE FROM BEFORE */
/*****************************************************************
* Build Unix shell commands in arrays. Then execute them with system
* calls.

    char LogUpdte [100];
    char LogSort  [100];
    char ReqUpdte [100];
    char ReqSort  [100];
   sprintf(LogUpdte,"cat %s >> /unarchive/login_names  ",argv[2]);
   sprintf(ReqUpdte,"cat %s >> /unarchive/,to.do ",argv[1]);
   sprintf(LogSort,"sort -u -o /unarchive/login_names /unarchive/login_names");
   sprintf(ReqSort,"sort -u -o /unarchive/,to.do /unarchive/,to.do");

   system(ReqUpdte);
   system(LogUpdte);
   system(ReqSort);
   system(LogSort);

******************************************************************/
